/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.gnunet.construct.MessageUnion;
import org.gnunet.construct.ProtocolViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLoader {
    private static final Logger logger;
    private static Map<Class<? extends MessageUnion>, Map<Integer, Class<? extends MessageUnion>>> unionmap;
    private static Map<Class<? extends MessageUnion>, Map<Class<? extends MessageUnion>, Integer>> tagmap;

    public static void loadMessageMap(URL loc) {
        if (loc == null) {
            throw new RuntimeException("could not load message map");
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(loc.openStream(), Charsets.UTF_8));
            while ((line = in.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] m = line.split("=");
                if (m.length != 2) {
                    throw new RuntimeException("invalid message map format (separation by '=')");
                }
                String[] left = m[0].split("[|]");
                if (left.length != 2) {
                    logger.debug(m[0]);
                    logger.debug(m[1]);
                    logger.debug("split in " + left.length);
                    throw new RuntimeException("invalid message map format (left hand side)");
                }
                int id = Integer.parseInt(left[1].trim());
                String unionCaseName = m[1].trim();
                String unionInterfaceName = left[0];
                Class<? extends MessageUnion> unionInterface = MessageLoader.loadClass(unionInterfaceName);
                Class<? extends MessageUnion> unionCase = MessageLoader.loadClass(unionCaseName);
                if (!unionmap.containsKey(unionInterface)) {
                    unionmap.put(unionInterface, new HashMap(5));
                }
                unionmap.get(unionInterface).put(id, unionCase);
                if (!tagmap.containsKey(unionInterface)) {
                    tagmap.put(unionInterface, new HashMap(5));
                }
                tagmap.get(unionInterface).put(unionCase, id);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("could not read message map");
            }
            catch (Throwable throwable) {
                MessageLoader.maybeClose(in);
                throw throwable;
            }
        }
        MessageLoader.maybeClose(in);
    }

    private static void maybeClose(Closeable in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error closing stream: " + e.getMessage());
        }
    }

    private static Class<? extends MessageUnion> loadClass(String className) {
        Class<?> msgClass;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            msgClass = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)String.format("message class '%s' not found in classpath", className));
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)String.format("Class %s does not inherit from MessageUnion", className));
        }
        return msgClass;
    }

    public static Class<? extends MessageUnion> getUnionClass(Class<? extends MessageUnion> unionInterface, int tag) {
        Map<Integer, Class<? extends MessageUnion>> map = unionmap.get(unionInterface);
        if (map == null) {
            throw new UnknownUnionException("don't know how to handle unions of type '" + unionInterface + "'");
        }
        Class<? extends MessageUnion> cls = map.get(tag);
        if (cls == null) {
            throw new ProtocolViolationException("don't know how to translate message of type " + tag);
        }
        return cls;
    }

    public static int getUnionTag(Class<? extends MessageUnion> unionInterface, Class<? extends MessageUnion> unionCase) {
        Map<Class<? extends MessageUnion>, Integer> map = tagmap.get(unionInterface);
        if (map == null) {
            throw new AssertionError((Object)String.format("%s is not a known union type", unionInterface));
        }
        if (!map.containsKey(unionCase)) {
            throw new AssertionError((Object)String.format("%s is not a known instance of %s", unionCase, unionInterface));
        }
        return map.get(unionCase);
    }

    public static Class<? extends MessageUnion>[] getUnionCases(Class<? extends MessageUnion> unionInterface) {
        Map<Class<? extends MessageUnion>, Integer> map = tagmap.get(unionInterface);
        return map.keySet().toArray(new Class[map.keySet().size()]);
    }

    public static void registerUnionCase(Class<? extends MessageUnion> unionInterface, Class<? extends MessageUnion> unionCase, int tag) {
        if (!unionmap.containsKey(unionInterface)) {
            unionmap.put(unionInterface, new HashMap(5));
        }
        unionmap.get(unionInterface).put(tag, unionCase);
        if (!tagmap.containsKey(unionInterface)) {
            tagmap.put(unionInterface, new HashMap(5));
        }
        tagmap.get(unionInterface).put(unionCase, tag);
    }

    static {
        Enumeration<URL> resources;
        logger = LoggerFactory.getLogger(MessageLoader.class);
        unionmap = new HashMap<Class<? extends MessageUnion>, Map<Integer, Class<? extends MessageUnion>>>(100);
        tagmap = new HashMap<Class<? extends MessageUnion>, Map<Class<? extends MessageUnion>, Integer>>(100);
        ClassLoader classLoader = MessageLoader.class.getClassLoader();
        try {
            resources = classLoader.getResources("org/gnunet/construct/MsgMap.txt");
        }
        catch (IOException e) {
            throw new RuntimeException("something went wrong with loading MsgMap.txt");
        }
        while (resources.hasMoreElements()) {
            MessageLoader.loadMessageMap(resources.nextElement());
        }
        if (tagmap.isEmpty()) {
            logger.warn("message map empty");
        }
    }

    public static class UnknownUnionIdException
    extends RuntimeException {
    }

    public static class UnknownUnionException
    extends RuntimeException {
        public UnknownUnionException(String msg) {
            super(msg);
        }
    }
}

