/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.peerinfo;

import org.gnunet.hello.HelloMessage;
import org.gnunet.mq.Envelope;
import org.gnunet.peerinfo.PeerProcessor;
import org.gnunet.peerinfo.messages.InfoEnd;
import org.gnunet.peerinfo.messages.InfoMessage;
import org.gnunet.peerinfo.messages.ListAllPeersMessage;
import org.gnunet.peerinfo.messages.ListPeerMessage;
import org.gnunet.requests.Request;
import org.gnunet.requests.SequentialRequestContainer;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerInfo {
    private static final Logger logger = LoggerFactory.getLogger(PeerInfo.class);
    private final Client client;
    private SequentialRequestContainer<PeerIterateRequest> iterateRequests;

    public PeerInfo(Configuration cfg) {
        this.client = new Client("peerinfo", cfg);
        this.client.installReceiver(new PeerInfoMessageReceiver());
        this.iterateRequests = new SequentialRequestContainer(this.client);
    }

    public Cancelable iterate(RelativeTime timeout, boolean friendOnly, PeerProcessor processor) {
        return this.iterate(timeout, null, friendOnly, processor);
    }

    public Cancelable iterate(RelativeTime timeout, PeerIdentity peer, boolean friendOnly, PeerProcessor processor) {
        PeerIterateRequest r = new PeerIterateRequest(peer, friendOnly, processor);
        return this.iterateRequests.addRequest(r);
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public static void main(String ... args) {
        new Program(){

            @Override
            public void run() {
                final PeerInfo peerInfo = new PeerInfo(this.getConfiguration());
                peerInfo.iterate(RelativeTime.FOREVER, false, new PeerProcessor(){

                    @Override
                    public void onPeer(PeerIdentity peerIdentity, HelloMessage hello) {
                        System.out.println("peer " + peerIdentity.toString());
                    }

                    @Override
                    public void onEnd() {
                        System.out.println("got peer end");
                        peerInfo.disconnect();
                    }
                });
            }
        }.start(args);
    }

    private class PeerInfoMessageReceiver
    extends RunaboutMessageReceiver {
        private PeerInfoMessageReceiver() {
        }

        public void visit(InfoEnd infoEnd) {
            PeerIterateRequest r = (PeerIterateRequest)PeerInfo.this.iterateRequests.getAndRetireRequest();
            if (!r.canceled) {
                r.peerProcessor.onEnd();
            }
        }

        public void visit(InfoMessage infoMessage) {
            PeerIterateRequest r = (PeerIterateRequest)PeerInfo.this.iterateRequests.getRequest();
            if (!r.canceled) {
                r.peerProcessor.onPeer(infoMessage.peerIdentity, infoMessage.hello);
            }
        }

        @Override
        public void handleError() {
            PeerInfo.this.client.reconnect();
            PeerInfo.this.iterateRequests.restart();
        }
    }

    private class PeerIterateRequest
    extends Request {
        public PeerIdentity peer;
        public PeerProcessor peerProcessor;
        public boolean friendOnly;
        public boolean canceled;

        public PeerIterateRequest(PeerIdentity peer, boolean friendOnly, PeerProcessor peerProcessor) {
            this.peer = peer;
            this.peerProcessor = peerProcessor;
            this.friendOnly = friendOnly;
        }

        @Override
        public Envelope assembleRequest() {
            if (this.peer == null) {
                ListAllPeersMessage m = new ListAllPeersMessage();
                m.includeFriendOnly = this.friendOnly ? 1 : 0;
                return new Envelope(m);
            }
            ListPeerMessage m = new ListPeerMessage();
            m.peer = this.peer;
            return new Envelope(m);
        }

        public void onCancel() {
            this.canceled = true;
        }
    }
}

