/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.testbed;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import org.gnunet.testbed.CompressedConfig;
import org.gnunet.testbed.ControllerStatusCallback;
import org.gnunet.testbed.Host;
import org.gnunet.testbed.messages.HelperInitMessage;
import org.gnunet.testbed.messages.HelperReplyMessage;
import org.gnunet.util.Helper;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerProc {
    private static final Logger logger = LoggerFactory.getLogger(ControllerProc.class);
    private Helper helper;
    private ControllerStatusCallback cb;
    private Host host;

    public void start(String trustedIP, Host host, ControllerStatusCallback cb) {
        this.cb = cb;
        this.host = host;
        if (!host.isLocal()) {
            throw new AssertionError((Object)"not implemented yet");
        }
        ArrayList<String> args = new ArrayList<String>();
        this.helper = new Helper(false, "gnunet-helper-testbed", args, new ControllerProcReceiver());
        this.helper.send(this.makeHelperInitMessage(trustedIP, host));
    }

    public void stop() {
        logger.debug("stopping controller");
        this.helper.kill(false);
    }

    private HelperInitMessage makeHelperInitMessage(String trustedIP, Host host) {
        HelperInitMessage m = new HelperInitMessage();
        if (host.hostname == null) {
            m.hostname = new byte[0];
            m.hostname_size = 0;
        } else {
            m.hostname_size = host.hostname.length();
            m.hostname = host.hostname.getBytes(Charsets.UTF_8);
        }
        m.trusted_ip_size = trustedIP.length();
        m.trusted_ip = trustedIP;
        CompressedConfig ccfg = new CompressedConfig(host.cfg);
        m.compressed_config = ccfg.compressedData;
        m.config_size = ccfg.getUncompressedSize();
        return m;
    }

    public class ControllerProcReceiver
    extends RunaboutMessageReceiver {
        public void visit(HelperReplyMessage m) {
            System.out.println("got controller proc message");
            CompressedConfig ccfg = new CompressedConfig(m.compressed_config);
            ((ControllerProc)ControllerProc.this).host.cfg = ccfg.decompress();
            ControllerProc.this.cb.onStartupSuccess(((ControllerProc)ControllerProc.this).host.cfg);
        }

        @Override
        public void handleError() {
            ControllerProc.this.cb.onStartupFailure();
        }
    }
}

