/* mktrans.c: -*- C -*-  DESCRIPTIVE TEXT. */

/*  Copyright (c) 1996 Brian J. Fox
    Author: Brian J. Fox (bfox@ai.mit.edu) Sat Mar 16 16:37:34 1996.  */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "gd.h"

int
main (int argc, char *argv[])
{
  register int i = 1;
  int transcol = -1;

  while (i < argc)
    {
      char *arg = argv[i++];

      if (strcmp (arg, "-i") == 0)
	{
	  transcol = atoi (argv[i++]);
	}
      else
	{
	  FILE *stream = fopen (arg, "r");
	  gdImagePtr image = (gdImagePtr)0;

	  if (stream != (FILE *)NULL)
	    {
	      image = gdImageCreateFromGif (stream);
	      fclose (stream);
	    }
	  else
	    {
	      fprintf (stderr, "Cannot read image: %s\n", arg);
	      continue;
	    }

	  if (image != (gdImagePtr)0)
	    {
	      int color =
		transcol == -1 ? gdImageGetPixel (image, 0, 0) : transcol;

	      gdImageColorTransparent (image, color);

	      stream = fopen (arg, "w");

	      if (stream != (FILE *)NULL)
		{
		  gdImageGif (image, stream);
		  fclose (stream);
		}
	      else
		{
		  fprintf (stderr, "Cannot write image: %s\n", arg);
		}
	    }
	}
    }
  return (0);
}
