/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "Player.h"
#include "Board.h"
#include <vector>
#include "RandomGenerator.h"
#include "MottiRulesManager.h"
class AiPlayer 
{
public:
	struct coordinate2DM{
		coordinate2DM(int px,int py,Case *caseCoordp=NULL):x(px),y(py),caseCoord(caseCoordp),value(0.0){};
		int x;
		int y;
		Case *caseCoord;
		double value;
	};
	AiPlayer(Player *,MottiRulesManager *);
	~AiPlayer(void);
	//think on the actual Game
	virtual void think( Board *);
	RandomGenerator &getRandomGenerator();

protected :
	virtual void colorize( Board *);
	void searchEnnemyHouse(Board *b);
	double calculateValue(Board *b,int x,int y);
	void orderByPrecision();
	void attack(Board *b);
	void guerilla(Board *b);
	void play(Board *b);
	bool isGuerillable();
	coordinate2DM calculateMinValue();
	bool nearIsLocked(Board *b,int x,int y);
	Player *player_;
	double maxdistance_;
	double attackprecision_;
	std::vector<coordinate2DM> vectEnnemyHouse_;
	std::vector<coordinate2DM> vectColorizedCoord_;
	std::vector<coordinate2DM> lastChoice_;
	RandomGenerator randGen_;
	MottiRulesManager *rules_;
};

