/*  mem.c - memory wrappers
    Copyright (C) 2005-2006  Jia Wang (skyroam@gmail.com) 
    
    This file is part of Proxyknife.

    Proxyknife is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Proxyknife is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include<proxyknife.h>
#include<stdlib.h>
#include<stdio.h>
#include<proxyknife.h>
#include <assert.h>

/* global, outside thread  */

/* Free memory the pointer point to  and set the memory pointer to NULL */
void
xfree (void **p)
{
        assert(p != NULL);
  if (*p != NULL)
          free (*p);
  *p = NULL;
  /* shorten link! */
  /* link->p == NULL */
}

/* Set all memory pointers to NULL */
void
mem_init ()
{
  user_agent = NULL;
  logfilename = NULL;
  target.key = NULL;

  my.myhost = NULL;
  my.myuser = NULL;
  my.mypass = NULL;

  my.myuserpass = NULL;
  my.header_auth = NULL;
  my.socks5authreq = NULL;

  target.target = NULL;
  target.targethost = NULL;
  target.targetport = NULL;
  target.targetpath = NULL;
}

/* This is not necessary for common operating system */
/* Free all memory the  non-NULL memory pointer point to, then exit. */
void
xexit (int status)
{
  /* clean global memory */
  /* efficiency is'nt important to exit with little memory cleaned */
  if (logfilename)
    free (logfilename);
  if (user_agent)
    free (user_agent);
  if (target.key)
    free (target.key);
  if (my.myhost)
    free (my.myhost);
  if (my.myuser)
    free (my.myuser);
  if (my.mypass)
    free (my.mypass);
  if (my.myuserpass)
    free (my.myuserpass);
  if (my.header_auth)
    free (my.header_auth);
  if (my.socks5authreq)
    free (my.socks5authreq);
  if (target.target)
    free (target.target);
  if (target.targethost)
    free (target.targethost);
  if (target.targetport)
    free (target.targetport);
  if (target.targetpath)
    free (target.targetpath);
  /* for compatible with mytype do not exist, implent this 
     within xmalloc && init.
     init: NULL for all
     xmalloc: non-NULL for sucess.
     so this code can be changed from
     if(my.mytype==HTTP_CONNECT_AUTH){
     free(my.header_auth);
     }
     to:
     if(my.header_auth) free(my.header_auth).

     even loop{if(i)free(i->xxx);i=..}

   */

  /* exit with exit 2 */
  exit (status);
}

/* A malloc wrapper with error check.
 * */
void *
xmalloc (size_t size)
{
  void *p;
  p = malloc (size);
  if (p == NULL)
    {				/* atexit */
      fprintf (stderr, "%s: xmalloc:Need more memory\n", progname);
      /* the pointer requesting memory is still NULL */
      xexit (EXIT_FAILURE);	/* atexit will do this similarly */
    }
  else
    {
      /* add to memlist */
      /* p-> link */
      return p;
    }
}

/* A realloc wrapper with error check.
 * */
void *
xrealloc (void *ptr, size_t size)
{
  void *p;
  p = realloc (ptr, size);

  /* if NULL , ptr may be destroied for realloc bug. here we ignored it .
     Otherwise, we should know &ptr and rest ptr to NULL if it happened. 
   */
  if (p == NULL)
    {
      xexit (EXIT_FAILURE);
    }
  else
    {
      return p;
    }
}

/************* thread *******************************************/
#include <pthread.h>
/* Free all memory the non-NULL memory pointer point to ,then exit thread */
void
x_pthread_exit (void *retval, struct thread_mem *thread_mem)
{
  if (thread_mem->line)
    free (thread_mem->line);
  if (thread_mem->queue.testproxy)
    free (thread_mem->queue.testproxy);
  if (thread_mem->request)
    free (thread_mem->request);
  if (thread_mem->reply)
    free (thread_mem->reply);
  pthread_exit (retval);
}

/* A realloc wrapper with error check and mutex lock inside thread. */
void *
pxrealloc (void *ptr, size_t size, struct thread_mem *thread_mem)
{
  void *p;
  int ret = EXIT_FAILURE;
  pthread_mutex_lock (&counter_mutex_malloc);
  p = realloc (ptr, size);
  /* if NULL , ptr may be destroied for realloc bug. here we ignored it .
     Otherwise, we should know &ptr and rest ptr to NULL if it happened. 
   */
  if (p == NULL)
    {
      pthread_mutex_unlock (&counter_mutex_malloc);
      x_pthread_exit ((void *) &ret, thread_mem);
    }
  else
    {
      pthread_mutex_unlock (&counter_mutex_malloc);
      return p;
    }
}

/* A malloc wrapper with error check and mutex lock inside thread. */
void *
pxmalloc (size_t size, struct thread_mem *thread_mem)
{
  void *p;
  int ret = EXIT_FAILURE;

  pthread_mutex_lock (&counter_mutex_malloc);
  p = malloc (size);
  if (p == NULL)
    {				/* atexit */
      fprintf (stderr, "%s: pxmalloc:Need more memory\n", progname);
      pthread_mutex_unlock (&counter_mutex_malloc);
      x_pthread_exit ((void *) &ret, thread_mem);
    }
  else
    {				/* add to memlist */
      pthread_mutex_unlock (&counter_mutex_malloc);
      return p;
    }
}

/* Set all memory pointer to NULL. */
void
thread_mem_init (struct thread_mem *thread_mem)
{
  thread_mem->line = NULL;
  thread_mem->queue.testproxy = NULL;
  thread_mem->request = NULL;
  thread_mem->reply = NULL;
}



/* Now no mutex_lock needed,every thread free  different var */
/* Free memory */
void
pxfree (void **p)
{
        assert(p!=NULL);
  if (*p)
    free (*p);
  *p = NULL;
  /* shorten link! */
  /* link->p == NULL */
}
