/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_do_refresh.h
 * @brief implementation of the do_refresh function for Postgres
 * @author Özgür Kesim
 */
#ifndef PG_DO_REFRESH_H
#define PG_DO_REFRESH_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"
/**
   * Perform refresh operation--introduced with v26 of the API--,
   * checking for sufficient balance of the coin and possibly persisting the melt/refresh details.
   *
   * @param cls the plugin-specific state
   * @param[in,out] refresh refresh operation details; the noreveal_index
   *                is set in case the coin was already melted before
   * @param timestamp the timestamp of this melt operation, helpful for the coin history.
   * @param[in,out] zombie_required true if the melt must only succeed
   *			if the coin is a zombie, set to false if the requirement was satisfied
   * @param[out] found set to true if there exists already an entry in the database for
   *			the calculated commitment hash.
   * @param[out] noreveal_index if @e idempotent ist true, the existing value of the noreveal_index.
   * @param[out] nonce_reuse set to true if the blinding seed for CS was re-used.
   * @param[out] balance_ok set to true if the balance was sufficient
   * @param[out] coin_balance if balance_ok is false, set to the remaining value of the coin
   * @return query execution status, NO_RESULTS in case of an unknown coin.
   */
enum GNUNET_DB_QueryStatus
TEH_PG_do_refresh (
  void *cls,
  struct TALER_EXCHANGEDB_Refresh_v27 *refresh,
  const struct GNUNET_TIME_Timestamp *timestamp,
  bool *found,
  uint32_t *noreveal_index,
  bool *zombie_required,
  bool *nonce_reuse,
  bool *balance_ok,
  struct TALER_Amount *coin_balance);

#endif
