/* redisplay.c generated by valac 0.52.0, the Vala compiler
 * generated from redisplay.vala, do not modify */

/* Terminal independent redisplay routines

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

extern Window* head_wp;
extern Window* cur_wp;

void resize_windows (void);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gsize term_width (void);
gsize term_height (void);
void window_delete (Window* self);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void recenter (Window* wp);
gsize buffer_offset_to_line (Buffer* self,
                             gsize offset);
gsize window_o (Window* self);
void redisplay_init (void);
static gboolean __lambda118_ (glong uniarg,
                       GeeQueue* args);
void term_clear (void);
void term_redisplay (void);
void term_refresh (void);
static gboolean ___lambda118__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)

static gpointer
_window_ref0 (gpointer self)
{
#line 23 "src/redisplay.vala"
	return self ? window_ref (self) : NULL;
#line 193 "redisplay.c"
}

void
resize_windows (void)
{
	Window* wp = NULL;
	gint hdelta = 0;
	{
		Window* _tmp0_;
		Window* _tmp1_;
		gboolean _tmp2_ = FALSE;
#line 23 "src/redisplay.vala"
		_tmp0_ = head_wp;
#line 23 "src/redisplay.vala"
		_tmp1_ = _window_ref0 (_tmp0_);
#line 23 "src/redisplay.vala"
		_window_unref0 (wp);
#line 23 "src/redisplay.vala"
		wp = _tmp1_;
#line 23 "src/redisplay.vala"
		_tmp2_ = TRUE;
#line 23 "src/redisplay.vala"
		while (TRUE) {
#line 217 "redisplay.c"
			Window* _tmp6_;
			Window* _tmp7_;
			Window* _tmp8_;
#line 23 "src/redisplay.vala"
			if (!_tmp2_) {
#line 223 "redisplay.c"
				Window* _tmp3_;
				Window* _tmp4_;
				Window* _tmp5_;
#line 23 "src/redisplay.vala"
				_tmp3_ = wp;
#line 23 "src/redisplay.vala"
				_tmp4_ = _tmp3_->next;
#line 23 "src/redisplay.vala"
				_tmp5_ = _window_ref0 (_tmp4_);
#line 23 "src/redisplay.vala"
				_window_unref0 (wp);
#line 23 "src/redisplay.vala"
				wp = _tmp5_;
#line 237 "redisplay.c"
			}
#line 23 "src/redisplay.vala"
			_tmp2_ = FALSE;
#line 23 "src/redisplay.vala"
			_tmp6_ = wp;
#line 23 "src/redisplay.vala"
			if (!(_tmp6_ != NULL)) {
#line 23 "src/redisplay.vala"
				break;
#line 247 "redisplay.c"
			}
#line 24 "src/redisplay.vala"
			_tmp7_ = wp;
#line 24 "src/redisplay.vala"
			_tmp8_ = wp;
#line 24 "src/redisplay.vala"
			_tmp8_->fwidth = term_width ();
#line 24 "src/redisplay.vala"
			_tmp7_->ewidth = _tmp8_->fwidth;
#line 257 "redisplay.c"
		}
	}
	{
		Window* _tmp9_;
		Window* _tmp10_;
		gboolean _tmp11_ = FALSE;
#line 29 "src/redisplay.vala"
		hdelta = ((gint) term_height ()) - 1;
#line 29 "src/redisplay.vala"
		_tmp9_ = head_wp;
#line 29 "src/redisplay.vala"
		_tmp10_ = _window_ref0 (_tmp9_);
#line 29 "src/redisplay.vala"
		_window_unref0 (wp);
#line 29 "src/redisplay.vala"
		wp = _tmp10_;
#line 29 "src/redisplay.vala"
		_tmp11_ = TRUE;
#line 29 "src/redisplay.vala"
		while (TRUE) {
#line 278 "redisplay.c"
			Window* _tmp16_;
#line 29 "src/redisplay.vala"
			if (!_tmp11_) {
#line 282 "redisplay.c"
				Window* _tmp12_;
				Window* _tmp13_;
				Window* _tmp14_;
				Window* _tmp15_;
#line 31 "src/redisplay.vala"
				_tmp12_ = wp;
#line 31 "src/redisplay.vala"
				hdelta -= (gint) _tmp12_->fheight;
#line 31 "src/redisplay.vala"
				_tmp13_ = wp;
#line 31 "src/redisplay.vala"
				_tmp14_ = _tmp13_->next;
#line 31 "src/redisplay.vala"
				_tmp15_ = _window_ref0 (_tmp14_);
#line 31 "src/redisplay.vala"
				_window_unref0 (wp);
#line 31 "src/redisplay.vala"
				wp = _tmp15_;
#line 301 "redisplay.c"
			}
#line 29 "src/redisplay.vala"
			_tmp11_ = FALSE;
#line 30 "src/redisplay.vala"
			_tmp16_ = wp;
#line 30 "src/redisplay.vala"
			if (!(_tmp16_ != NULL)) {
#line 30 "src/redisplay.vala"
				break;
#line 311 "redisplay.c"
			}
		}
	}
#line 35 "src/redisplay.vala"
	if (hdelta > 0) {
#line 317 "redisplay.c"
		{
			Window* _tmp17_;
			Window* _tmp18_;
			gboolean _tmp19_ = FALSE;
#line 36 "src/redisplay.vala"
			_tmp17_ = head_wp;
#line 36 "src/redisplay.vala"
			_tmp18_ = _window_ref0 (_tmp17_);
#line 36 "src/redisplay.vala"
			_window_unref0 (wp);
#line 36 "src/redisplay.vala"
			wp = _tmp18_;
#line 36 "src/redisplay.vala"
			_tmp19_ = TRUE;
#line 36 "src/redisplay.vala"
			while (TRUE) {
#line 334 "redisplay.c"
				Window* _tmp23_;
				Window* _tmp26_;
				Window* _tmp27_;
				gsize _tmp28_;
				Window* _tmp29_;
				gsize _tmp30_;
				gint _tmp31_;
#line 36 "src/redisplay.vala"
				if (!_tmp19_) {
#line 344 "redisplay.c"
					Window* _tmp20_;
					Window* _tmp21_;
					Window* _tmp22_;
#line 36 "src/redisplay.vala"
					_tmp20_ = wp;
#line 36 "src/redisplay.vala"
					_tmp21_ = _tmp20_->next;
#line 36 "src/redisplay.vala"
					_tmp22_ = _window_ref0 (_tmp21_);
#line 36 "src/redisplay.vala"
					_window_unref0 (wp);
#line 36 "src/redisplay.vala"
					wp = _tmp22_;
#line 358 "redisplay.c"
				}
#line 36 "src/redisplay.vala"
				_tmp19_ = FALSE;
#line 36 "src/redisplay.vala"
				if (!(hdelta > 0)) {
#line 36 "src/redisplay.vala"
					break;
#line 366 "redisplay.c"
				}
#line 37 "src/redisplay.vala"
				_tmp23_ = wp;
#line 37 "src/redisplay.vala"
				if (_tmp23_ == NULL) {
#line 372 "redisplay.c"
					Window* _tmp24_;
					Window* _tmp25_;
#line 38 "src/redisplay.vala"
					_tmp24_ = head_wp;
#line 38 "src/redisplay.vala"
					_tmp25_ = _window_ref0 (_tmp24_);
#line 38 "src/redisplay.vala"
					_window_unref0 (wp);
#line 38 "src/redisplay.vala"
					wp = _tmp25_;
#line 383 "redisplay.c"
				}
#line 39 "src/redisplay.vala"
				_tmp26_ = wp;
#line 39 "src/redisplay.vala"
				_vala_assert (_tmp26_ != NULL, "wp != null");
#line 40 "src/redisplay.vala"
				_tmp27_ = wp;
#line 40 "src/redisplay.vala"
				_tmp27_->fheight = _tmp27_->fheight + 1;
#line 40 "src/redisplay.vala"
				_tmp28_ = _tmp27_->fheight;
#line 41 "src/redisplay.vala"
				_tmp29_ = wp;
#line 41 "src/redisplay.vala"
				_tmp29_->eheight = _tmp29_->eheight + 1;
#line 41 "src/redisplay.vala"
				_tmp30_ = _tmp29_->eheight;
#line 42 "src/redisplay.vala"
				hdelta = hdelta - 1;
#line 42 "src/redisplay.vala"
				_tmp31_ = hdelta;
#line 405 "redisplay.c"
			}
		}
	} else {
		{
			gboolean decreased = FALSE;
#line 45 "src/redisplay.vala"
			decreased = TRUE;
#line 413 "redisplay.c"
			{
				gboolean _tmp32_ = FALSE;
#line 45 "src/redisplay.vala"
				_tmp32_ = TRUE;
#line 45 "src/redisplay.vala"
				while (TRUE) {
#line 45 "src/redisplay.vala"
					if (!_tmp32_) {
#line 422 "redisplay.c"
					}
#line 45 "src/redisplay.vala"
					_tmp32_ = FALSE;
#line 45 "src/redisplay.vala"
					if (!decreased) {
#line 45 "src/redisplay.vala"
						break;
#line 430 "redisplay.c"
					}
#line 46 "src/redisplay.vala"
					decreased = FALSE;
#line 434 "redisplay.c"
					{
						Window* _tmp33_;
						Window* _tmp34_;
						gboolean _tmp35_ = FALSE;
#line 47 "src/redisplay.vala"
						_tmp33_ = head_wp;
#line 47 "src/redisplay.vala"
						_tmp34_ = _window_ref0 (_tmp33_);
#line 47 "src/redisplay.vala"
						_window_unref0 (wp);
#line 47 "src/redisplay.vala"
						wp = _tmp34_;
#line 47 "src/redisplay.vala"
						_tmp35_ = TRUE;
#line 47 "src/redisplay.vala"
						while (TRUE) {
#line 451 "redisplay.c"
							gboolean _tmp39_ = FALSE;
							Window* _tmp40_;
							Window* _tmp41_;
#line 47 "src/redisplay.vala"
							if (!_tmp35_) {
#line 457 "redisplay.c"
								Window* _tmp36_;
								Window* _tmp37_;
								Window* _tmp38_;
#line 47 "src/redisplay.vala"
								_tmp36_ = wp;
#line 47 "src/redisplay.vala"
								_tmp37_ = _tmp36_->next;
#line 47 "src/redisplay.vala"
								_tmp38_ = _window_ref0 (_tmp37_);
#line 47 "src/redisplay.vala"
								_window_unref0 (wp);
#line 47 "src/redisplay.vala"
								wp = _tmp38_;
#line 471 "redisplay.c"
							}
#line 47 "src/redisplay.vala"
							_tmp35_ = FALSE;
#line 47 "src/redisplay.vala"
							_tmp40_ = wp;
#line 47 "src/redisplay.vala"
							if (_tmp40_ != NULL) {
#line 47 "src/redisplay.vala"
								_tmp39_ = hdelta < 0;
#line 481 "redisplay.c"
							} else {
#line 47 "src/redisplay.vala"
								_tmp39_ = FALSE;
#line 485 "redisplay.c"
							}
#line 47 "src/redisplay.vala"
							if (!_tmp39_) {
#line 47 "src/redisplay.vala"
								break;
#line 491 "redisplay.c"
							}
#line 48 "src/redisplay.vala"
							_tmp41_ = wp;
#line 48 "src/redisplay.vala"
							if (_tmp41_->fheight > ((gsize) 2)) {
#line 497 "redisplay.c"
								Window* _tmp42_;
								gsize _tmp43_;
								Window* _tmp44_;
								gsize _tmp45_;
								gint _tmp46_;
#line 49 "src/redisplay.vala"
								_tmp42_ = wp;
#line 49 "src/redisplay.vala"
								_tmp42_->fheight = _tmp42_->fheight - 1;
#line 49 "src/redisplay.vala"
								_tmp43_ = _tmp42_->fheight;
#line 50 "src/redisplay.vala"
								_tmp44_ = wp;
#line 50 "src/redisplay.vala"
								_tmp44_->eheight = _tmp44_->eheight - 1;
#line 50 "src/redisplay.vala"
								_tmp45_ = _tmp44_->eheight;
#line 51 "src/redisplay.vala"
								hdelta = hdelta + 1;
#line 51 "src/redisplay.vala"
								_tmp46_ = hdelta;
#line 52 "src/redisplay.vala"
								decreased = TRUE;
#line 521 "redisplay.c"
							} else {
								gboolean _tmp47_ = FALSE;
								Window* _tmp48_;
								Window* _tmp49_;
#line 53 "src/redisplay.vala"
								_tmp48_ = cur_wp;
#line 53 "src/redisplay.vala"
								_tmp49_ = head_wp;
#line 53 "src/redisplay.vala"
								if (_tmp48_ != _tmp49_) {
#line 53 "src/redisplay.vala"
									_tmp47_ = TRUE;
#line 534 "redisplay.c"
								} else {
									Window* _tmp50_;
									Window* _tmp51_;
#line 53 "src/redisplay.vala"
									_tmp50_ = cur_wp;
#line 53 "src/redisplay.vala"
									_tmp51_ = _tmp50_->next;
#line 53 "src/redisplay.vala"
									_tmp47_ = _tmp51_ != NULL;
#line 544 "redisplay.c"
								}
#line 53 "src/redisplay.vala"
								if (_tmp47_) {
#line 548 "redisplay.c"
									Window* new_wp = NULL;
									Window* _tmp52_;
									Window* _tmp53_;
									Window* _tmp54_;
									Window* _tmp55_;
									Window* _tmp56_;
									Window* _tmp57_;
									Window* _tmp58_;
#line 54 "src/redisplay.vala"
									_tmp52_ = wp;
#line 54 "src/redisplay.vala"
									_tmp53_ = _tmp52_->next;
#line 54 "src/redisplay.vala"
									_tmp54_ = _window_ref0 (_tmp53_);
#line 54 "src/redisplay.vala"
									new_wp = _tmp54_;
#line 55 "src/redisplay.vala"
									_tmp55_ = wp;
#line 55 "src/redisplay.vala"
									window_delete (_tmp55_);
#line 56 "src/redisplay.vala"
									_tmp56_ = new_wp;
#line 56 "src/redisplay.vala"
									_tmp57_ = _window_ref0 (_tmp56_);
#line 56 "src/redisplay.vala"
									_window_unref0 (wp);
#line 56 "src/redisplay.vala"
									wp = _tmp57_;
#line 57 "src/redisplay.vala"
									_tmp58_ = wp;
#line 57 "src/redisplay.vala"
									_vala_assert (_tmp58_ != NULL, "wp != null");
#line 58 "src/redisplay.vala"
									decreased = TRUE;
#line 53 "src/redisplay.vala"
									_window_unref0 (new_wp);
#line 585 "redisplay.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 64 "src/redisplay.vala"
	funcall ("recenter", NULL, NULL);
#line 20 "src/redisplay.vala"
	_window_unref0 (wp);
#line 598 "redisplay.c"
}

void
recenter (Window* wp)
{
	gsize n = 0UL;
	Buffer* _tmp0_;
#line 67 "src/redisplay.vala"
	g_return_if_fail (wp != NULL);
#line 68 "src/redisplay.vala"
	_tmp0_ = wp->bp;
#line 68 "src/redisplay.vala"
	n = buffer_offset_to_line (_tmp0_, window_o (wp));
#line 70 "src/redisplay.vala"
	if (n > (wp->eheight / 2)) {
#line 71 "src/redisplay.vala"
		wp->topdelta = wp->eheight / 2;
#line 616 "redisplay.c"
	} else {
#line 73 "src/redisplay.vala"
		wp->topdelta = n;
#line 620 "redisplay.c"
	}
}

static gboolean
__lambda118_ (glong uniarg,
              GeeQueue* args)
{
	Window* _tmp0_;
	gboolean result = FALSE;
#line 81 "src/redisplay.vala"
	_tmp0_ = cur_wp;
#line 81 "src/redisplay.vala"
	recenter (_tmp0_);
#line 82 "src/redisplay.vala"
	term_clear ();
#line 83 "src/redisplay.vala"
	term_redisplay ();
#line 84 "src/redisplay.vala"
	term_refresh ();
#line 85 "src/redisplay.vala"
	result = TRUE;
#line 85 "src/redisplay.vala"
	return result;
#line 644 "redisplay.c"
}

static gboolean
___lambda118__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda118_ (uniarg, args);
#line 78 "src/redisplay.vala"
	return result;
#line 655 "redisplay.c"
}

void
redisplay_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 78 "src/redisplay.vala"
	_tmp0_ = lisp_func_new ("recenter", ___lambda118__function, TRUE, "Center point in selected window and redisplay frame.");
#line 78 "src/redisplay.vala"
	_tmp1_ = _tmp0_;
#line 78 "src/redisplay.vala"
	_lisp_func_unref0 (_tmp1_);
#line 669 "redisplay.c"
}

