#! /bin/sh
# -*- ksh -*-

: ${SRCDIR=.}
. $SRCDIR/defs || exit 1

# This program compares what produces two distinct versions of the program

# Same but with -g
GREF_DIR=$top_srcdir/check/gps-ref
GCHK_DIR=$top_builddir/check/gps-chk

# Here are stored the diff of outputs by both programs
DIFF=$top_builddir/check/ps-diff
GDIFF=$top_builddir/check/gps-diff

# What is the log file
LOGFILE=$top_srcdir/check/styles.log
# LOG="2>&1 >> $LOGFILE"
LOG=

# value at exit
exit_val=0

# Remove trash
/bin/rm -f $TST_DIR/*~ $PS_DIFF $GPS_DIFF $LOGFILE 2> /dev/null

# Make sure the directories exist
for dir in $GREF_DIR $GCHK_DIR $DIFF $GDIFF
do
  [ -d "$dir" ] || mkdir $dir
  chmod u+wrx $dir
done

echo "-------------------------------------------"
echo "	Comparing generated postscripts"
echo "-------------------------------------------"

# We explicitely give the style sheet to use, because:
# - it avoids the problems with broken file(1)
# - it is not the purpose of this test to test automatic style selection
# - some languages share the same suffix

for pair in $TEST_FILES
do
  filename=`echo $pair | sed "s/:.*//"g`
  lang=`echo $pair | sed "s/[^:]*://"g`
  echo $echo_n "$filename	($lang)... 	$echo_c"
  if [ ! -f "$TST_DIR/$filename" ]; then
    echo $ac_t "is not a test file"
    continue
  fi

  # If the file has a `.', then sed the suffix to ps
  # Otherwise, add `.ps'
  if echo "$filename" | grep \\. >/dev/null; then
    psfilename=`echo $filename | sed -e 's/\..*/.ps/g'`
  else
    psfilename=$filename.ps
  fi

  # The name of the input file
  file=$TST_DIR/$filename

  # What produces this tested program ?
  eval "$CHK -E$lang -P awkout $file > $CHK_DIR/$psfilename" $LOG
  eval "$CHK -Cgs2 -E$lang -P awkout $file > $GCHK_DIR/$psfilename" $LOG

  # Build the originals if there are not here, and protect them
  if [ ! -r "$REF_DIR/$psfilename" ]; then
    eval "$REF -E$lang -P awkout $file > $REF_DIR/$psfilename" $LOG
  fi
  if [ ! -r "$GREF_DIR/$psfilename" ]; then
    eval "$REF -Cgs2 -E$lang -P awkout $file > $GREF_DIR/$psfilename" $LOG
  fi

  # And now the diff
  diff $REF_DIR/$psfilename $CHK_DIR/$psfilename > $DIFF/$filename
  nbdiff=`wc -l $DIFF/$filename | awk '{print $1}'`
  diff $GREF_DIR/$psfilename $GCHK_DIR/$psfilename> $GDIFF/$filename
  nbdiffsym=`wc -l $GDIFF/$filename |awk '{print $1}'`
  if [ "$nbdiff" = 0 -a "$nbdiffsym" = 0 ]; then
    echo "Ok"
  else
    echo "Bad: -ng -> $nbdiff, -g -> $nbdiffsym"
  fi
done

# Sumary of the diff's
cd $DIFF
wc -l `ls` | sort -u | grep -v "^[ \t]*0" > $top_builddir/check/sum-ps-diff

if [ -n "`cat $top_builddir/check/sum-ps-diff`" ]; then
  echo "  There are differences with reference PostScript files:"
  cat $top_builddir/check/sum-ps-diff
  exit_val=1
fi

cd $GDIFF
wc -l `ls` | sort -u | grep -v "^[ \t]*0" > $top_builddir/check/sum-gps-diff

if [ -n "`cat $top_builddir/check/sum-gps-diff`" ]; then
  echo "  There are differences with reference PostScript files (with -g):"
  cat $top_builddir/check/sum-gps-diff
  exit_val=1
fi

exit $exit_val
