/* scattering.h -- This file is part of Archimedes release 0.0.1.
   Archimedes is a simulator for Submicron 2D Silicon
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 06 sep.2004, Siracusa, J.M.Sellier
// Last modif. : 07 Oct.2004, Siracusa, J.M.Sellier
// ######################################################

// calculation of the various scattering process
// In the present version (0.0.1) we take into account
// acoustic phonons scattering and all the non-polar optical phonons
// scattering which are the most relevant in Silicon devices.

void
scat(void)
{
 int j=0;
 register int i,ie;
 real ksquared,thesquareroot,superparticle_energy;
 real r1,finalenergy=0.,finalk,cosinus,sinus,fai;

  if(IV==9) return;

  ksquared=KX*KX+KY*KY+KZ*KZ;
  thesquareroot=sqrt(1.+4.*alphaSILICON*HHM*ksquared);
  superparticle_energy=(thesquareroot-1.)/(2.*alphaSILICON);
  if(superparticle_energy<=0.) return;
  ie=((int)(superparticle_energy/DE))+1;
  if(ie>DIME) ie=DIME;

// Selection of scattering process
  r1 = rnd();
// Non-Polar optical phonons
  for(i=1;i<=6;i++){
// Emission of an optical phonon
    if(r1<=SWK[i*2-1][ie] && j==0){
       finalenergy=superparticle_energy-SiHWO[i-1];
       j=1;
    }
// Absorbation of an optical phonon
    if((r1<=SWK[i*2][ie]) && j==0){
       finalenergy=superparticle_energy+SiHWO[i-1];
       j=1;
    }
  }
// Acoustic phonon
  if((r1<=SWK[13][ie]) && j==0){
     finalenergy=superparticle_energy;
     j=1;
  }
  if((finalenergy<=0.) || j==0) return;

// determination of the final states
  finalk = SMH*sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
  cosinus = 1.-2.*rnd();
  sinus = sqrt(1.-cosinus*cosinus);
  fai = 2.*PI*rnd();
  KX = finalk*cosinus;
  KY = finalk*sinus*cos(fai);
  KZ = finalk*sinus*sin(fai);
}

// ===============================================
