dnl  -*- Mode: M4 -*- 
dnl --------------------------------------------------------------------
dnl libregex.m4 --- compiler switches to link with POSIX regex library.
dnl 
dnl Author:	       Gary V. Vaughan <gvaughan@localhost>
dnl Maintainer:	       Gary V. Vaughan <gvaughan@localhost>
dnl Created:	       Mon Nov 16 15:14:19 1998
dnl Last Modified:     Tue Jun 15 09:31:21 1999				      
dnl            by:           Bruce Korb <korb@datadesign.com>		      
dnl --------------------------------------------------------------------
dnl @(#) $Id: libregex.m4,v 1.3 1999/06/15 16:35:28 bkorb Exp $
dnl --------------------------------------------------------------------
dnl 
dnl Code:

# serial 2

dnl AG_CHECK_LIB_REGEX
dnl Add switches for prefix and library name, and add any necessary
dnl switches to INCLUDES, LDFLAGS and LIBS.
dnl

AC_DEFUN([AG_CHECK_LIB_REGEX],
[AC_MSG_CHECKING([whether POSIX regex library was specified])
ag_cv_with_included_regex="no"
ag_cv_lib_regex_prefix="none"
ag_cv_lib_regex_library="none"
ag_lib_regex_result=""

AC_ARG_WITH(included-regex,
[  --with-included-regex   use the GNU regex library included with AutoGen],
[ag_cv_with_included_regex=$with_included_regex])
AC_ARG_WITH(regex-prefix,
[  --with-regex-prefix     prefix of a POSIX regex library installation[none]],
[ag_cv_lib_regex_prefix=$with_regex_prefix])
AC_ARG_WITH(regex-lib,
[  --with-regex-lib        name of a POSIX regex library to link with[none]],
[ag_cv_lib_regex_library=$with_regex_lib])

if test x$ag_cv_with_included_regex != xno; then
    ag_lib_regex_result="included GNU regex"
else
    if test x$ag_cv_lib_regex_prefix != xnone; then
        ag_lib_regex_result="-L${ag_cv_lib_regex_prefix}/lib "
        if test x$ag_cv_lib_regex_library = xnone; then
	    ag_cv_lib_regex_library=regex
        fi
    fi

    if test x$ag_cv_lib_regex_library != xnone; then
        ag_lib_regex_result="${ag_lib_regex_result}-l$ag_cv_lib_regex_library"
    else
        ag_lib_regex_result=no
    fi
fi

AC_MSG_RESULT([$ag_lib_regex_result])

#  IF no special library was specified,
#  THEN check for one that came with the system.
#  If that one is not POSIX, then we will include our own.
#
if test x$ag_cv_with_included_regex = xno; then
    AG_CHECK_POSIX_REGCOMP
    if test x$ag_cv_posix_regcomp != xyes
    then
        ag_cv_with_included_regex="yes"
    fi
fi

if test x$ag_cv_with_included_regex != xno; then
    AC_DEFINE(WITH_INCLUDED_REGEX, 1,
	      [Define this to use the GNU regex included with AutoGen])
fi

if test x$ag_cv_lib_regex_prefix != xnone; then
    CPPFLAGS="-I${ag_cv_lib_regex_prefix}/include $CPPFLAGS"
    LDFLAGS="-L${ag_cv_lib_regex_prefix}/lib $LDFLAGS"
fi
if test x$ag_cv_lib_regex_library != xnone; then
    LIBS="-l$ag_cv_lib_regex_library $LIBS"
fi])

dnl libregex.m4 ends here
