/* cfengine for GNU
 
        Copyright (C) 1995/6,2000
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/

/*****************************************************************************/
/*                                                                           */
/* File: filters.c                                                           */
/*                                                                           */
/*****************************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"

/*******************************************************************/
/* Parser                                                          */
/*******************************************************************/

void InstallFilter(filter)

char *filter;

{ struct Filter *ptr;
  int i;
 
Debug1("InstallFilter(%s)\n",filter);

if (FilterExists(filter))
   {
   yyerror("Redefinition of existing filter");
   return;
   }

if (! IsInstallable(CLASSBUFF))
   {
   InitializeAction();
   Debug1("Not installing Edit no match\n");
   return;
   }

if ((ptr = (struct Filter *)malloc(sizeof(struct Filter))) == NULL)
   {
   FatalError("Memory Allocation failed for InstallFilterFilter() #1");
   }

if ((ptr->alias = strdup(filter)) == NULL)
   {
   FatalError("Memory Allocation failed for InstallFilterFilter() #2");
   }
 
if ((ptr->classes = strdup(CLASSBUFF)) == NULL)
   {
   FatalError("Memory Allocation failed for InstallFilterFilter() #3");
   }
 
if (VFILTERLISTTOP == NULL)                 /* First element in the list */
   {
   VFILTERLIST = ptr;
   }
else
   {
   VFILTERLISTTOP->next = ptr;
   }

for (i = 0; i < NoFilter; i++)
   {
   ptr->criteria[i] = NULL;
   }
 
ptr->next = NULL;
VFILTERLISTTOP = ptr;
}

/********************************************************************/

void InstallFilterTest(alias,type,data)

char *alias,*type,*data;

{ enum filternames FilterActionsToCode();
  int crit = (int) FilterActionsToCode(type);
  struct Filter *fp;
  char buffer[bufsize];
  time_t now;
  
Debug("InstallFilterTest(%s,%s,%s)\n",alias,type,data);

buffer[0] = '\0'; 
ExpandVarstring(data,buffer,NULL);
 
if (crit == NoFilter)
   {
   yyerror("Unknown filter criterion");
   }
else
   {
   for (fp = VFILTERLIST; fp != NULL; fp = fp->next)
      {
      if (strcmp(alias,fp->alias) == 0)
	 {
         switch (crit)
	    {
	    case filterresult:
		IsInstallable(buffer); /* syntax check */
		break;

	    case filterfromctime:
		now = Date2Number(buffer,now);
		break;
	    case filtertoctime:
		break;
	    case filterfrommtime:
		break;
	    case filtertomtime:
		break;
	    case filterfromatime:
		break;
	    case filtertoatime:
		break;
	    case filterfromsize:
		break;
	    case filtertosize:
		break;
	    case filtertyperegex:
		/* test here */
		break;
	    case filternameregex:
		/* test here */
		break;
	    case filterexec:
		/* test here */
		break;
	    }
	 
	 if ((fp->criteria[crit] = strdup(buffer)) == NULL)
	    {
	    CfLog(cferror,"Couldn't allocate filter memory","strdup");
	    FatalError("Dying..");
	    }
	 else
	    {
	    return;
	    }
	 }
      }
   }
}

/********************************************************************/

enum filternames FilterActionsToCode(filtertype)

char *filtertype;

{ int i;

Debug1("FilterActionsToCode(%s)\n",filtertype);

if (filtertype[strlen(filtertype)-1] != ':')
   {
   yyerror("Syntax error in filter type");
   return NoFilter;
   }

filtertype[strlen(filtertype)-1] = '\0';
 
for (i = 0; VFILTERNAMES[i] != '\0'; i++)
   {
   if (strcmp(VFILTERNAMES[i],filtertype) == 0)
      {
      return (enum filternames) i;
      }
   }

return (NoFilter);
}

/*******************************************************************/

int FilterExists(name)

char *name;

{ struct Filter *ptr;

for (ptr=VFILTERLIST; ptr != NULL; ptr=ptr->next)
   {
   if (strcmp(ptr->alias,name) == 0)
      {
      return true;
      }
   }
return false;
}

/*******************************************************************/
/* Filter code                                                     */
/* These functions return true if the input matches the search crit*/
/*******************************************************************/

int ProcessFilter(proc,filterlist)

char *proc;
struct Item *filterlist;

{ struct Item *classes;
 
 Debug("ProcessFilter()\n");

if (filterlist == NULL)
   {
   return true;
   }

return false; 
}

/*******************************************************************/

int FileObjectFilter(file,statptr,filterlist,context)

char *file;
struct stat *statptr;
struct Item *filterlist;
enum actions context;

{ struct Item *classes;
 Debug("FileObjectFilter()\n");
 
 
if (filterlist == NULL)
   {
   return true;
   }

return false; 
}
