/* LocaleInformation_af.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_af extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ZAR";

  private static final String currenciesDisplayNameValues = "Rand";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ZAR";

  private static final String currenciesSymbolValues = "R";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mei",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Des",
    null,
  };

  private static final String[] months = {
    "Januarie",
    "Februarie",
    "Maart",
    "April",
    "Mei",
    "Junie",
    "Julie",
    "Augustus",
    "September",
    "Oktober",
    "November",
    "Desember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "So",
    "Ma",
    "Di",
    "Wo",
    "Do",
    "Vr",
    "Sa",
  };

  private static final String[] weekdays = {
    null,
    "Sondag",
    "Maandag",
    "Dinsdag",
    "Woensdag",
    "Donderdag",
    "Vrydag",
    "Saterdag",
  };

  private static final String[] eras = {
    "v.C.",
    "n.C.",
  };

  private static final String[] ampms = {
    "vm.",
    "nm.",
  };

  private static final String territoriesKeys = "AU|TD|AT|GW|AR|MZ|MY|MX|GR|AM|ZA|MV|GQ|AL|SY|GN|MR|GM|SV|AG|AF|ST|AE|MN|SP|MK|SO|GE|MH|MG|GB|SK|GA|SI|SG|MA|SE|SD|SC|SB|SA|YE|LY|FR|LV|LU|LT|LR|FM|RU|FJ|RO|LB|KZ|ET|ES|KW|KR|KP|KN|KM|EH|EG|EE|KH|KG|KE|DZ|QA|DO|DK|JO|DJ|JM|DE|PL|VN|PH|PG|CZ|CY|CV|CU|VC|VA|IT|IS|CN|CM|IQ|CL|UZ|IN|CI|CH|CG|CF|US|CA|IE|ID|BY|BT|BR|UA|NZ|HU|HT|BO|BN|HR|TZ|NR|BH|BG|BF|TT|NO|BE|BD|TR|NL|BA|TN|TM|TJ|NE|AZ|ZM|NA";

  private static final String territoriesValues = "Australi\u00eb|Tsjaad|Oostenryk|Guinee-Bissau|Argentini\u00eb|Mosambiek|Maleisi\u00eb|Meksiko|Griekeland|Armeni\u00eb|Suid-Afrika|Maldive|Ekwatoriaal-Guinee|Albani\u00eb|Siri\u00eb|Guinee|Mouritani\u00eb|Gambi\u00eb|Salvador|Antigua en Barbuda|Afganistan|Sao Tome en Principe|Verenigde Arabiese Emirate|Mongoli\u00eb|Serwi\u00eb|Macedoni\u00eb|Somali\u00eb|Georgi\u00eb|Marshall-eilande|Madagaskar|Groot-Brittanje|Slowakye|Gaboen|Sloweni\u00eb|Singapoer|Marokko|Swede|Soedan|Seychelle|Solomon Eilande|Saoedi-Arabi\u00eb|Jemen|Libi\u00eb|Frankryk|Letland|Luxemburg|Litaue|Liberi\u00eb|Mikronesi\u00eb|Rusland|Fidji|Roemeni\u00eb|Libanon|Kasakstan|Ethiopi\u00eb|Spanje|Koeweit|Suid-Korea|Noord-Korea|Saint Kitts en Nevis|Comore|Wes-Sahara|Egipte|Estland|Kambodja|Kirgisi\u00eb|Kenia|Algeri\u00eb|Katar|Dominikaanse Republiek|Denemarke|Jordani\u00eb|Djiboeti|Jamaika|Duitsland|Pole|Vi\u00ebtnam|Filippyne|Papoea Nieu-Guinee|Tjeggiese Republiek|Ciprus|Kaap Verde|Kuba|Saint Vincent en die Grenadine|Vatikaan|Itali\u00eb|Ysland|Sjina|Kameroen|Irak|Chili|Oesbekistan|Indi\u00eb|Ivoorkus|Switserland|Kongo|Sentraal-Afrikaanse Republiek|Verenigde State van Amerika|Kanada|Ierland|Indonesi\u00eb|Wit-Rusland|Bhoetan|Brasili\u00eb|Oekraine|Nieu-Seeland|Hongarye|Ha\u00efti|Bolivi\u00eb|Broenei|Kroasi\u00eb|Tanzani\u00eb|Naoeroe|Bahrein|Bulgarye|Boerkina Fasso|Trinidad en Tobago|Noorwe\u00eb|Belgi\u00eb|Bangladesj|Turkye|Nederland|Bosni\u00eb en Herzegowina|Tunisi\u00eb|Turkmeni\u00eb|Tadjikistan|Nigeri\u00eb|Aserbeidjan|Zambi\u00eb|Namibi\u00eb";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "af";

  private static final String languagesValues = "Afrikaans";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
