/*** MODULE ATRDEF ***/
/* Attribute list description. The attribute control list is used to read and */
/* write file attributes. It consists of concatenated attribute control blocks */
/* terminated by a single zero longword.                                    */
/*                                                                          */
#define ATR$C_UCHAR 		0x003	/* 4 byte user file characteristics  */
#define ATR$C_RECATTR 		0x004	/* 32 bytes record attributes       */
#define ATR$C_FILNAM 		0x005   /* 6 byte rad-50 file name          */
#define ATR$C_FILTYP 		0x006   /* 2 byte rad-50 file type          */
#define ATR$C_FILVER 		0x007   /* 2 byte binary file version       */
#define ATR$C_EXPDAT 		0x008   /* 7 byte ascii expiration date     */
#define ATR$C_STATBLK 		0x009   /* 32 byte statistics block         */
#define ATR$C_HEADER 		0x00A	/* 512 byte file header             */
#define ATR$C_BLOCKSIZE 	0x00B	/* magtape block size               */
#define ATR$C_USERLABEL 	0x00C	/* user file label                  */
#define ATR$C_ASCDATES 		0x00D	/* revision count thru exp date in ascii  */
#define ATR$C_ALCONTROL 	0x00E	/* compatibility mode allocation data  */
#define ATR$C_ENDLBLAST 	0x00F	/* end of magtape label processing and supply ast control block  */
#define ATR$C_ASCNAME 		0x010	/* file name, type & version in ascii  */
#define ATR$C_CREDATE 		0x011	/* 64 bit creation date             */
#define ATR$C_REVDATE 		0x012	/* 64 bit revision date             */
#define ATR$C_EXPDATE 		0x013	/* 64 bit expiration date           */
#define ATR$C_BAKDATE 		0x014	/* 64 bit backup date               */
#define ATR$C_UIC 		0x015	/* 4 byte file owner uic            */
#define ATR$C_FPRO 		0x016	/* 2 byte file protection           */
#define ATR$C_RPRO 		0x017	/* 2 byte record protection         */
#define ATR$C_ACLEVEL 		0x018	/* 1 byte file access level         */
#define ATR$C_SEMASK 		0x019	/* file security mask and limit     */
#define ATR$C_UIC_RO 		0x01A	/* read only uic                    */
#define ATR$C_DIRSEQ 		0x01B	/* directory update sequence count  */
#define ATR$C_BACKLINK 		0x01C	/* file back link pointer           */
#define ATR$C_JOURNAL 		0x01D	/* journal control flags            */
#define ATR$C_HDR1_ACC 		0x01E	/* ansi tape header 1 accessibility  */
/*  character                                                               */
#define ATR$C_ADDACLENT 	0x01F	/* add an access control entry      */
#define ATR$C_DELACLENT 	0x020	/* remove an access control entry   */
#define ATR$C_MODACLENT 	0x021	/* modify an acl entry              */
#define ATR$C_FNDACLENT 	0x022	/* locate an acl entry              */
#define ATR$C_FNDACLTYP 	0x023	/* find a specific type of ace      */
#define ATR$C_DELETEACL 	0x024	/* delete the entire acl            */
#define ATR$C_READACL 		0x025	/* read the entire acl              */
#define ATR$C_ACLLENGTH 	0x026	/* return the length of the acl     */
#define ATR$C_READACE 		0x027	/* read a single ace                */
#define ATR$C_RESERVED 		0x028	/* modify reserved area             */
#define ATR$C_HIGHWATER 	0x029	/* highwater mark (user read only)     */
#define ATR$C_DUMMY_0 		0x02A	/* *** available code               */
#define ATR$C_PRIVS_USED 	0x02B	/* privileges used to gain access   */
#define ATR$C_MATCHING_ACE 	0x02C	/* ace used to gain access (if any) */
#define ATR$C_ACCESS_MODE 	0x02D	/* access mode for following attribute descriptors */
#define ATR$C_FILE_SPEC 	0x02E	/* convert fid to file-spec         */
#define ATR$C_CLASS_MASK 	0x02F	/* Non-discretionary classification mask */
#define ATR$C_BUFFER_OFFSET 	0x030	/* For magnetic tape only length of buffer offset of block in file */
/* All new attributes should be                                             */
/*  added here before MAX_PLUS1                                             */
#define ATR$C_MAX_PLUS1 	0x031	/* Maximum code plus one            */
#define ATR$C_MAX_CODE 		0x030
#define ATR$C_FNDACETYP 	0x023
/* attribute maximum lengths                                                */
#define ATR$S_UCHAR 		0x004	/* 4 byte user file characteristics  */
#define ATR$S_RECATTR 		0x020	/* 32 bytes record attributes       */
#define ATR$S_FILNAM            0x006   /* 6 byte rad-50 file name          */
#define ATR$S_FILTYP            0x002	/* 2 byte rad-50 file type          */
#define ATR$S_FILVER            0x002	/* 2 byte binary file version       */
#define ATR$S_EXPDAT            0x007   /* 7 byte ascii expiration date     */
#define ATR$S_STATBLK 		0x020	/* 32 byte statistics block         */
#define ATR$S_HEADER 		0x0200	/* 512 byte file header             */
#define ATR$S_BLOCKSIZE 	0x002	/* magtape block size               */
#define ATR$S_USERLABEL 	0x050	/* user file label                  */
#define ATR$S_ASCDATES 		0x023	/* revision count thru exp date in ascii  */
#define ATR$S_ALCONTROL 	0x00E	/* compatibility mode allocation data  */
#define ATR$S_ENDLBLAST 	0x004	/* end of magtape label processing and supply ast control block  */
#define ATR$S_ASCNAME           0x056   /* file name, type & version in ascii  */
#define ATR$S_CREDATE 		0x008	/* 64 bit creation date             */
#define ATR$S_REVDATE 		0x008	/* 64 bit revision date             */
#define ATR$S_EXPDATE 		0x008	/* 64 bit expiration date           */
#define ATR$S_BAKDATE 		0x008	/* 64 bit backup date               */
#define ATR$S_UIC 		0x004	/* 4 byte file owner uic            */
#define ATR$S_FPRO 		0x002	/* 2 byte file protection           */
#define ATR$S_RPRO 		0x002	/* 2 byte record protection         */
#define ATR$S_ACLEVEL 		0x001	/* 1 byte file access level         */
#define ATR$S_SEMASK            0x008   /* file security mask and limit     */
#define ATR$S_UIC_RO 		0x004	/* read only uic                    */
#define ATR$S_DIRSEQ 		0x002	/* directory update sequence count  */
#define ATR$S_BACKLINK          0x006	/* file back link pointer           */
#define ATR$S_JOURNAL           0x002	/* journal control flags            */
#define ATR$S_HDR1_ACC          0x001	/* ansi tape header 1 accessibility  */
/*  character                                                               */
#define ATR$S_ADDACLENT 	0x0FF 	/* add an access control entry      */
#define ATR$S_DELACLENT 	0x0FF   /* remove an access control entry   */
#define ATR$S_MODACLENT 	0x0FF   /* modify an acl entry              */
#define ATR$S_FNDACLENT 	0x0FF   /* locate an acl entry              */
#define ATR$S_FNDACLTYP 	0x0FF   /* find a specific type of ace      */
#define ATR$S_FNDACETYP 	0x0FF   /* find a specific type of ace      */
#define ATR$S_DELETEACL 	0x0FF   /* delete the entire acl            */
#define ATR$S_READACL 		0x200	/* read the entire acl              */
#define ATR$S_ACLLENGTH 	0x004	/* return the length of the acl     */
#define ATR$S_READACE 		0x0FF   /* read a single ace                */
#define ATR$S_RESERVED 		0x17C	/* modify reserved area             */
#define ATR$S_HIGHWATER 	0x004	/* file high water mark (user read only)     */
#define ATR$S_DUMMY_0 		0x004 	/* *** available code               */
#define ATR$S_PRIVS_USED 	0x004   /* privs used to gain access        */
#define ATR$S_MATCHING_ACE 	0x0FF   /* ace used to gain access          */
#define ATR$S_ACCESS_MODE 	0x001   /* access mode for following attribute descriptors */
#define ATR$S_FILE_SPEC 	0x200	/* convert fid to file-spec         */
#define ATR$S_CLASS_MASK 	0x014	/* Non-discretionary classification mask */
#define ATR$S_BUFFER_OFFSET 	0x002	/* Buffer offset length field       */
struct atrdef {
    unsigned short int atr$w_size;      /* size of attribute in bytes       */
    unsigned short int atr$w_type;      /* attribute type code              */
    unsigned long int atr$l_addr;       /* address of attribute text        */
/* attribute codes                                                          */
    } ;
 
