/*	LNMDEF - Logical name flag definitions 				   */

#define LNM$M_NO_ALIAS 1
#define LNM$M_CONFINE 2
#define LNM$M_CRELOG 4
#define LNM$M_TABLE 8
#define LNM$M_CONCEALED 256
#define LNM$M_TERMINAL 512
#define LNM$M_EXISTS 1024
#define LNM$M_SHAREABLE 65536
#define LNM$M_CREATE_IF 16777216
#define LNM$M_CASE_BLIND 33554432
struct lnmdef {
/* Logical name attributes -- bits 0-7                                      */
    unsigned lnm$v_no_alias : 1;        /* Do not allow outer mode alias    */
    unsigned lnm$v_confine : 1;         /* Do not copy into subprocess      */
    unsigned lnm$v_crelog : 1;          /* Created with old $CRELOG service */
    unsigned lnm$v_table : 1;           /* This is a table name             */
    unsigned lnm$v_fill_0 : 4;          /* Fill out logical name byte       */
/* Logical name translation attributes -- bits 8-15                         */
    unsigned lnm$v_concealed : 1;       /* Do not display result of translation */
    unsigned lnm$v_terminal : 1;        /* Do not retranslate result of translation */
    unsigned lnm$v_exists : 1;          /* Translation does exist at this index */
    unsigned lnm$v_fill_1 : 5;          /* Fill out translation byte        */
/* Logical name table characteristics -- bits 16-23                         */
    unsigned lnm$v_shareable : 1;       /* Logical name table is shareable (S0 space) */
    unsigned lnm$v_fill_2 : 3;          /* Reserved bit numbers 17-19       */
    unsigned lnm$v_fill_3 : 4;          /* Fill out table byte              */
/* System service options -- bits 24-31                                     */
    unsigned lnm$v_create_if : 1;       /* May map to existing logical name table */
    unsigned lnm$v_case_blind : 1;      /* Perform case-insensitive translation */
    unsigned lnm$v_fill_4 : 6;          /* Fill out options byte            */
    } ;
#define LNM$C_TABNAMLEN 31              /* Maximum length of a name contained within a directory table */
#define LNM$C_NAMLENGTH 255             /* Maximum logical name / translation length */
#define LNM$C_MAXDEPTH 10               /* Maximum logical name recursion depth */
#define LNM$_INDEX 1                    /* Translation index                */
#define LNM$_STRING 2                   /* Translation string               */
#define LNM$_ATTRIBUTES 3               /* Attribute bits                   */
#define LNM$_TABLE 4                    /* Logical name table name          */
#define LNM$_LENGTH 5                   /* Length of translation string     */
#define LNM$_ACMODE 6                   /* Access mode of name              */
#define LNM$_MAX_INDEX 7                /* Maximum translation index        */
#define LNM$_PARENT 8                   /* Parent logical name table name   */
#define LNM$_LNMB_ADDR 9                /* Return LNM block address         */
/*  internal use by MTL                                                     */
/*  and mailbox UCB                                                         */
/* Define item list codes                                                   */
#define LNM$_CHAIN -1                   /* Chain to next list               */

/* LNM Itemlist for TRNLOG system service  				    */
/*	added by P.G.Mulgaonkar, SRI Robotics, 8 July 86 		    */
			
struct  LNM$ITEMLIST
		{
		unsigned short 	lnm$item_buflen;
		unsigned short 	lnm$item_code;
		char 		*lnm$item_buffer;
		char 		*lnm$item_retlen;
		int  		lnm$item_flag;
		} ;
