# make-prototype.awk: generate `prototype' HTML.

# Copyright (C) 2012 Free Software Foundation, Inc.

# This file is part of GNUnited Nations.

# GNUnited Nations is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# GNUnited Nations is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with GNUnited Nations.  If not, see <http://www.gnu.org/licenses/>.

# Read whole file to `text'.
{ text = text $0 RT }

END {

# Program's name to prepend error messages.
  my_name = "make-prototype.awk: "
# Default name of file with `generic' message.
  if(generic_file == "")
    generic_file = "generic.html"

  if (!match(text, /(<title>.*)(<\/div>.*<div id="footer">)(.*)/, parts))
    {
      print my_name \
        "`<title>' followed by `</div>' and `<div id=\"footer\">' not found" \
         > "/dev/stderr"
      exit 1
    }
  output = ""
  if (RSTART > 1)
    output = substr(text, 1, RSTART-1)
  output = output "<gnun></gnun>"\
    "<!-- This file is automatically generated by GNUnited Nations! -->\n" \
    parts[1] \
"\n" \
"<div style=\"font-size: small;\">\n" \
"<!--TRANSLATORS: Use space (SPC) as msgstr if you don't have notes.-->\n" \
"*GNUN-SLOT: TRANSLATOR'S NOTES*</div>\n" \
    parts[2]

  if(!match (parts[3], /(.*)(<p>.*[$]Date:.*)/, tail))
    {
      print my_name \
        "no `<p>' followed by `$Date:' after `<div id=\"footer\">' found" \
         > "/dev/stderr"
      exit 1
    }
  printf "%s", output tail[1] \
"\n" \
"<div class=\"translators-credits\">\n" \
"<!--TRANSLATORS: Use space (SPC) as msgstr if you don't want credits.-->\n" \
"*GNUN-SLOT: TRANSLATOR'S CREDITS*</div>\n" \
"<gnun>m4_include(`" generic_file "')</gnun> " tail[2]
}
