/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.IntegerUtil;
import org.gnunet.construct.parsers.Parser;

public class FixedSizeIntegerArrayParser
implements Parser {
    private final int byteSize;
    private final boolean signed;
    private final Field targetField;
    private final int elemNumber;

    public FixedSizeIntegerArrayParser(int elemNumber, boolean signed, int byteSize, Field f) {
        this.targetField = f;
        this.elemNumber = elemNumber;
        this.signed = signed;
        this.byteSize = byteSize;
    }

    @Override
    public int getSize(Message srcObj) {
        return this.byteSize * this.elemNumber;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        int size = 0;
        Class<?> arrayElementType = this.targetField.getType().getComponentType();
        if (!arrayElementType.isPrimitive()) {
            throw new AssertionError((Object)("IntegerFillParser is expected to be of primitive type, not " + arrayElementType));
        }
        Object arr = Array.newInstance(this.targetField.getType().getComponentType(), this.elemNumber);
        ReflectUtil.justSet(dstObj, this.targetField, arr);
        for (int i = 0; i < this.elemNumber; ++i) {
            long v;
            try {
                v = IntegerUtil.readLong(srcBuf, this.signed, this.byteSize);
            }
            catch (BufferUnderflowException e) {
                throw new ProtocolViolationException("fixed size array underflow: " + this.targetField.toString());
            }
            ReflectUtil.justSetArray(arr, i, v);
        }
        return size;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        int size = 0;
        Object arr = ReflectUtil.justGet(srcObj, this.targetField);
        if (Array.getLength(arr) != this.elemNumber) {
            throw new AssertionError((Object)"wrong number of elements");
        }
        for (int i = 0; i < Array.getLength(arr); ++i) {
            IntegerUtil.writeLong(Array.getLong(arr, i), dstBuf, this.signed, this.byteSize);
            size += this.byteSize;
        }
        return size;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
    }

    @Override
    public int getStaticSize() {
        return this.elemNumber * this.byteSize;
    }
}

