/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.gns;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.gnunet.construct.Construct;
import org.gnunet.construct.Message;
import org.gnunet.construct.MessageLoader;
import org.gnunet.construct.MessageUnion;
import org.gnunet.construct.UInt32;
import org.gnunet.construct.UInt64;
import org.gnunet.construct.VariableSizeIntegerArray;
import org.gnunet.gns.records.RecordData;
import org.gnunet.gns.records.UnknownRecordData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnsRecord
implements Message {
    private static final Logger logger = LoggerFactory.getLogger(GnsRecord.class);
    private static boolean registryInitialized;
    private static BiMap<String, Long> recordTypeMap;
    private static Map<Long, Class> recordClassMap;
    @UInt64
    public long expiration;
    @UInt32
    public long dataSize;
    @UInt32
    public long recordType;
    @UInt32
    public long flags;
    @VariableSizeIntegerArray(lengthField="dataSize", signed=true, bitSize=8)
    public byte[] recordDataBytes;

    public static void initializeRegistry() {
        Class<? extends MessageUnion>[] classes;
        if (registryInitialized) {
            return;
        }
        for (Class<? extends MessageUnion> aClass : classes = MessageLoader.getUnionCases(RecordData.class)) {
            String recordTypeString;
            try {
                Field field = aClass.getField("recordTypeString");
                recordTypeString = (String)field.get(null);
            }
            catch (NoSuchFieldException e) {
                logger.warn("RecordData class {} has no recordTypeString field");
                continue;
            }
            catch (IllegalAccessException e) {
                logger.warn("RecordData class {} can't access recordTypeString field");
                continue;
            }
            long recordTypeId = MessageLoader.getUnionTag(RecordData.class, aClass);
            recordTypeMap.put((Object)recordTypeString, (Object)recordTypeId);
            recordClassMap.put(recordTypeId, aClass);
        }
        registryInitialized = true;
    }

    public RecordData getRecordData() {
        GnsRecord.initializeRegistry();
        Class cls = recordClassMap.get(this.recordType);
        if (null == cls) {
            UnknownRecordData unknownRecordData = new UnknownRecordData();
            unknownRecordData.data = this.recordDataBytes;
        }
        return (RecordData)Construct.parseAs(this.recordDataBytes, cls);
    }

    public static GnsRecord createFromString(String typeString, String content) {
        long typeId = GnsRecord.getIdFromString(typeString);
        if (typeId < 0L) {
            return null;
        }
        return GnsRecord.createFromString(typeId, content);
    }

    public static GnsRecord createFromString(long typeId, String content) {
        Method mth;
        GnsRecord.initializeRegistry();
        Class cls = recordClassMap.get(typeId);
        if (null == cls) {
            return null;
        }
        try {
            mth = cls.getMethod("createFromString", String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (GnsRecord)mth.invoke(null, content);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static String getStringFromId(long typeId) {
        GnsRecord.initializeRegistry();
        if (!recordTypeMap.inverse().containsKey((Object)typeId)) {
            return null;
        }
        return (String)recordTypeMap.inverse().get((Object)typeId);
    }

    public static long getIdFromString(String typeString) {
        GnsRecord.initializeRegistry();
        if (!recordTypeMap.containsKey((Object)typeString)) {
            return -1L;
        }
        return (Long)recordTypeMap.get((Object)typeString);
    }

    static {
        recordTypeMap = HashBiMap.create();
        recordClassMap = Maps.newHashMap();
    }
}

