/*
 This file is part of GNUnet.
 (C) 2014 Christian Grothoff (and other contributing authors)

 GNUnet is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published
 by the Free Software Foundation; either version 3, or (at your
 option) any later version.

 GNUnet is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GNUnet; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 */
package org.gnunet.transport.messages;

import org.gnunet.construct.NestedMessage;
import org.gnunet.construct.UInt32;
import org.gnunet.construct.UnionCase;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.PeerIdentity;

/**
 * Message from the transport service to the library
 * asking to check if both processes agree about this
 * peers identity.
 * @author Florian Dold
 */
@UnionCase(360)
public class StartMessage implements GnunetMessage.Body {
    /**
     * 0: no options
     * 1: The 'self' field should be checked
     * 2: this client is interested in payload traffic
     */
    @UInt32
    public int options;

    /**
     * Identity we think we have.  If it does not match, the
     * receiver should print out an error message and disconnect.
     */
    @NestedMessage
    public PeerIdentity self;
}
