/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrologStream {
    protected static final boolean DEBUG = false;
    public static final CompoundTermTag filenameTag = CompoundTermTag.get("file_name", 1);
    public static final CompoundTermTag modeTag = CompoundTermTag.get("mode", 1);
    public static final CompoundTermTag aliasTag = CompoundTermTag.get("alias", 1);
    public static final CompoundTermTag positionTag = CompoundTermTag.get("position", 1);
    public static final CompoundTermTag endOfStreamTag = CompoundTermTag.get("end_of_stream", 1);
    public static final CompoundTermTag eofActionTag = CompoundTermTag.get("eof_action", 1);
    public static final CompoundTermTag repositionTag = CompoundTermTag.get("reposition", 1);
    public static final CompoundTermTag typeTag = CompoundTermTag.get("type", 1);
    public static final AtomTerm atAtom = AtomTerm.get("at");
    public static final AtomTerm pastAtom = AtomTerm.get("past");
    public static final AtomTerm notAtom = AtomTerm.get("not");
    public static final AtomTerm inputAtom = AtomTerm.get("input");
    public static final AtomTerm outputAtom = AtomTerm.get("output");
    public static final AtomTerm errorAtom = AtomTerm.get("error");
    public static final AtomTerm eofCodeAtom = AtomTerm.get("eof_code");
    public static final AtomTerm resetAtom = AtomTerm.get("reset");
    public static final AtomTerm repositionAtom = AtomTerm.get("reposition");
    public static final AtomTerm streamAtom = AtomTerm.get("stream");
    public static final AtomTerm readAtom = AtomTerm.get("read");
    public static final AtomTerm userInputAtom = AtomTerm.get("user_input");
    public static final AtomTerm userOutputAtom = AtomTerm.get("user_output");
    public static final AtomTerm textAtom = AtomTerm.get("text");
    public static final AtomTerm binaryAtom = AtomTerm.get("binary");
    public static final AtomTerm appendAtom = AtomTerm.get("append");
    public static final AtomTerm streamOrAliasAtom = AtomTerm.get("stream_or_alias");
    public static final AtomTerm openAtom = AtomTerm.get("open");
    public static final AtomTerm sourceSinkAtom = AtomTerm.get("source_sink");
    public static final AtomTerm writeAtom = AtomTerm.get("write");
    public static final AtomTerm endOfFileAtom = AtomTerm.get("end_of_file");
    protected AtomTerm filename;
    protected AtomTerm mode;
    protected AtomTerm reposition;
    protected AtomTerm eofAction;
    protected AtomTerm endOfStream = notAtom;
    protected AtomTerm type;
    protected Set<AtomTerm> aliases;
    protected Term streamTerm = new JavaObjectTerm(this);
    protected boolean closed = false;
    protected Environment environment;

    protected PrologStream(OpenOptions options) {
        this.filename = options.filename;
        this.mode = options.mode == readAtom ? inputAtom : outputAtom;
        this.reposition = options.reposition;
        this.eofAction = options.eofAction;
        this.type = options.type;
        this.aliases = new HashSet<AtomTerm>(options.aliases);
        this.environment = options.environment;
    }

    public void checkExists() throws PrologException {
        if (this.closed) {
            System.err.println(this.filename.value);
            PrologException.existenceError(streamAtom, this.streamTerm);
        }
    }

    public Term getStreamTerm() {
        return this.streamTerm;
    }

    public AtomTerm getMode() {
        return this.mode;
    }

    public void getProperties(List<Term> list) throws PrologException {
        list.add(new CompoundTerm(filenameTag, this.filename));
        list.add(this.mode);
        for (AtomTerm atomTerm : this.aliases) {
            list.add(new CompoundTerm(aliasTag, atomTerm));
        }
        if (this.reposition == TermConstants.trueAtom) {
            list.add(new CompoundTerm(positionTag, this.getPosition(this.streamTerm, null)));
        }
        list.add(new CompoundTerm(endOfStreamTag, this.getEndOfStreamState()));
        list.add(new CompoundTerm(eofActionTag, this.eofAction));
        list.add(new CompoundTerm(repositionTag, this.reposition));
        list.add(new CompoundTerm(typeTag, this.type));
    }

    public abstract int getByte(Term var1, Interpreter var2) throws PrologException;

    public abstract int peekByte(Term var1, Interpreter var2) throws PrologException;

    public abstract void putByte(Term var1, Interpreter var2, int var3) throws PrologException;

    public Term getEndOfStreamState() throws PrologException {
        this.checkExists();
        return this.endOfStream;
    }

    public abstract Term getPosition(Term var1, Interpreter var2) throws PrologException;

    public abstract void setPosition(Term var1, Interpreter var2, Term var3) throws PrologException;

    public abstract int getCode(Term var1, Interpreter var2) throws PrologException;

    public abstract int peekCode(Term var1, Interpreter var2) throws PrologException;

    public abstract void putCode(Term var1, Interpreter var2, int var3) throws PrologException;

    public abstract void putCodeSequence(Term var1, Interpreter var2, String var3) throws PrologException;

    public abstract Term readTerm(Term var1, Interpreter var2, ReadOptions var3) throws PrologException;

    public abstract void writeTerm(Term var1, Interpreter var2, WriteOptions var3, Term var4) throws PrologException;

    public abstract void flushOutput(Term var1) throws PrologException;

    public void close(boolean force) throws PrologException {
        if (this.environment.close(this)) {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getCurrentLine() {
        return -1;
    }

    public int getCurrentColumn() {
        return -1;
    }

    public Set<AtomTerm> getAliases() {
        return this.aliases;
    }

    protected void debug(Exception ex) {
    }

    public static class OpenOptions {
        public AtomTerm mode;
        public AtomTerm type = textAtom;
        public AtomTerm eofAction = eofCodeAtom;
        public AtomTerm reposition = TermConstants.falseAtom;
        public Set<AtomTerm> aliases = new HashSet<AtomTerm>();
        public AtomTerm filename;
        public Environment environment;

        public OpenOptions(AtomTerm filename, AtomTerm mode, Environment environment) {
            this.mode = mode;
            this.filename = filename;
            this.environment = environment;
            if (environment == null) {
                throw new IllegalArgumentException("Environment cannot be null");
            }
        }
    }
}

