#ifndef NFS_NFS_SPEC_H
#define NFS_NFS_SPEC_H

#define NFS_PORT 2049
#define NFS_MAXDATA 8192
#define NFS_MAXPATHLEN 1024
#define NFS_MAXNAMLEN 255
#define NFS2_FHSIZE 32
#define NFS3_FHSIZE 64
#define NFS_COOKIESIZE 4
#define NFS_FIFO_DEV -1
#define NFS3_COOKIEVERFSIZE 8
#define NFS3_CREATEVERFSIZE 8
#define NFS3_WRITEVERFSIZE 8
#define NFSMODE_FMT 0170000
#define NFSMODE_DIR 0040000
#define NFSMODE_CHR 0020000
#define NFSMODE_BLK 0060000
#define NFSMODE_REG 0100000
#define NFSMODE_LNK 0120000
#define NFSMODE_SOCK 0140000
#define NFSMODE_FIFO 0010000

enum nfsstat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,	/* v3 only */
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,	/* v3 only */
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,	/* v3 only */
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,	/* v3 only */
	NFSERR_WFLUSH = 99,	/* v2 only */
	NFSERR_BADHANDLE = 10001, /* v3 only */
	NFSERR_NOT_SYNC = 10002, /* v3 only */
	NFSERR_BAD_COOKIE = 10003, /* v3 only */
	NFSERR_NOTSUPP = 10004,	/* v3 only */
	NFSERR_TOOSMALL = 10005, /* v3 only */
	NFSERR_SERVERFAULT = 10006, /* v3 only */
	NFSERR_BADTYPE = 10007,	/* v3 only */
	NFSERR_JUKEBOX = 10008,	/* v3 only */
#define NFSERR_TRYLATER NFSERR_JUKEBOX
};


enum ftype {
	NF2NON = 0,		/* v2 only */
	NFREG = 1,
	NFDIR = 2,
	NFBLK = 3,
	NFCHR = 4,
	NFLNK = 5,
	NFSOCK = 6,
	NF3FIFO = 7,		/* v3 only */
#define NF2BAD NF3FIFO		/* v2 only */
	NF2FIFO = 8,		/* v2 only */
};

/* Ways to set the time in setattr structures */
enum sattr_time_how 
{
  DONT_CHANGE = 0,
  SET_TO_SERVER_TIME = 1,
  SET_TO_CLIENT_TIME = 2,
};

/* Construction of ACCESS arg to NFS3PROC_ACCESS. */
#define ACCESS3_READ     0x01
#define ACCESS3_LOOKUP   0x02
#define ACCESS3_MODIFY   0x04
#define ACCESS3_EXTEND   0x08
#define ACCESS3_DELETE   0x10
#define ACCESS3_EXECUTE  0x20

/* STABLE arg to NFS3PROC_READ */
enum stable_how {
  UNSTABLE = 0,
  DATA_SYNC = 1,
  FILE_SYNC = 2,
};

/* MODE arg to NFS3PROC_CREATE */
enum createmode 
{
  UNCHECKED = 0,
  GUARDED = 1,
  EXCLUSIVE = 2,
};

#define NFS_PROGRAM ((u_long)100003)
#define NFS_VERSION ((u_long)2)

#define NFS_PROTOCOL_FUNC(proc,vers) \
	(vers == 2 ? NFS2PROC_ ## proc : NFS3PROC_ ## proc)

#define NFSPROC_NULL(v) NFS_PROTOCOL_FUNC (NULL,v)
#define NFSPROC_GETATTR(v) NFS_PROTOCOL_FUNC (GETATTR, v)
#define NFSPROC_SETATTR(v) NFS_PROTOCOL_FUNC (SETATTR, v)
#define NFSPROC_LOOKUP(v) NFS_PROTOCOL_FUNC (LOOKUP, v)
#define NFSPROC_READLINK(v) NFS_PROTOCOL_FUNC (READLINK, v)
#define NFSPROC_READ(v) NFS_PROTOCOL_FUNC (READ, v)
#define NFSPROC_WRITE(v) NFS_PROTOCOL_FUNC (WRITE, v)
#define NFSPROC_CREATE(v) NFS_PROTOCOL_FUNC (CREATE, v)
#define NFSPROC_REMOVE(v) NFS_PROTOCOL_FUNC (REMOVE, v)
#define NFSPROC_RENAME(v) NFS_PROTOCOL_FUNC (RENAME, v)
#define NFSPROC_LINK(v) NFS_PROTOCOL_FUNC (LINK, v)
#define NFSPROC_SYMLINK(v) NFS_PROTOCOL_FUNC (SYMLINK, v)
#define NFSPROC_MKDIR(v) NFS_PROTOCOL_FUNC (MKDIR, v)
#define NFSPROC_RMDIR(v) NFS_PROTOCOL_FUNC (RMDIR, v)
#define NFSPROC_READDIR(v) NFS_PROTOCOL_FUNC (READDIR, v)

/* Values for each protocol */
#define NFS2PROC_NULL 0
#define NFS2PROC_GETATTR 1
#define NFS2PROC_SETATTR 2
#define NFS2PROC_ROOT 3
#define NFS2PROC_LOOKUP 4
#define NFS2PROC_READLINK 5
#define NFS2PROC_READ 6
#define NFS2PROC_WRITECACHE 7
#define NFS2PROC_WRITE 8
#define NFS2PROC_CREATE 9
#define NFS2PROC_REMOVE 10
#define NFS2PROC_RENAME 11
#define NFS2PROC_LINK 12
#define NFS2PROC_SYMLINK 13
#define NFS2PROC_MKDIR 14
#define NFS2PROC_RMDIR 15
#define NFS2PROC_READDIR 16
#define NFS2PROC_STATFS 17

#define NFS3PROC_NULL 0
#define NFS3PROC_GETATTR 1
#define NFS3PROC_SETATTR 2
#define NFS3PROC_LOOKUP 3
#define NFS3PROC_ACCESS 4
#define NFS3PROC_READLINK 5
#define NFS3PROC_READ 6
#define NFS3PROC_WRITE 7
#define NFS3PROC_CREATE 8
#define NFS3PROC_MKDIR 9
#define NFS3PROC_SYMLINK 10
#define NFS3PROC_MKNOD 11
#define NFS3PROC_REMOVE 12
#define NFS3PROC_RMDIR 13
#define NFS3PROC_RENAME 14
#define NFS3PROC_LINK 15
#define NFS3PROC_READDIR 16
#define NFS3PROC_READDIRPLUS 17
#define NFS3PROC_FSSTAT 18
#define NFS3PROC_FSINFO 19
#define NFS3PROC_PATHCONF 20
#define NFS3PROC_COMMIT 21

#endif /* NFS_NFS_SPEC_H */
