
;;; d-bat.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-bat.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: M.S.DOS batch file major mode
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

;; MS-DOS BATCH FILE MODE:

(defun bat-mode ()
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'bat-mode)
  (setq mode-name "Msdos Batch File")
  (make-local-variable 'font-lock-keywords-case-fold-search)
  ;;(setq-default font-lock-keywords-case-fold-search nil)
  (setq font-lock-keywords-case-fold-search t)
  ;;(d-bat--font-lock-mode-hook)
  ;;(font-lock-fontify-buffer)
  ;;(turn-on-fast-lock)
  (turn-on-font-lock)
  (run-hooks 'bat-mode-hook)
  )

(defun d-bat--font-lock-mode-hook ()
  (if (eq major-mode 'bat-mode)
      (progn
        ;;(d-foo)
        (d-font-lock-add-end
         '(
           ("%[a-zA-Z]+%" 0 font-lock-variable-name-face t)
           ("\\([- _.a-zA-Z0-9]+\\)=" 1 font-lock-variable-name-face t)
           ("[A-Z]:[^ ;\n]+" 0 font-lock-function-name-face t)
           ("\\." 0 font-lock-function-name-face t)
           (";" 0 font-lock-reference-face t)
           ("=" 0 font-lock-reference-face t)
           ("/[a-zA-Z]" 0 font-lock-function-name-face t)
           ("\\[\\sw+\\]" 0 font-lock-function-name-face t)
           ("\\<\\(set\\|rem\\)\\>" 0 font-lock-keyword-face t)
           ("\\<rem \\([^\n]*\\)$" 1 font-lock-comment-face t)
           ("---+" 0 font-lock-type-face t)
           ("---+ \\([a-zA-Z !:_-]+\\) ---+" 0 font-lock-type-face t)
           ("#.*$" 0 font-lock-comment-face t)
           ))
        ;;(turn-on-fast-lock)
        ;;(font-lock-fontify-buffer)
        ;;(setq font-lock-mode t)
        )))
(add-hook 'font-lock-mode-hook 'd-bat--font-lock-mode-hook)

(setq auto-mode-alist
      (append '(("\\.bat$" . bat-mode)
                ("\\.env"  . bat-mode)
                ("\\.sys$" . bat-mode)
                ("\\.ini$" . bat-mode)
                ("\\.win$" . bat-mode)
                )
                auto-mode-alist))

;;(setq auto-mode-alist nil)

(provide 'd-bat)
;;; d-bat.el ends here
