/*
 * Decompiled with CFR 0.152.
 */
package qalbum;

import gnu.text.Path;
import java.io.File;
import java.net.URI;
import qalbum.ImageInfo;
import qalbum.Thumbnail;

public class PictureInfo {
    static boolean autoScale = true;
    String label;
    ImageInfo original;
    ImageInfo large;
    ImageInfo medium;
    ImageInfo thumbnail;

    public static PictureInfo getImages(String string, String string2, Object object) throws Throwable {
        Path path;
        if (object instanceof URI) {
            object = new File((URI)object);
        }
        String string3 = object.toString();
        PictureInfo pictureInfo = new PictureInfo();
        pictureInfo.label = string;
        pictureInfo.original = ImageInfo.readMetadata(string3);
        String string4 = string3;
        int n = string3.lastIndexOf(46);
        int n2 = string3.length();
        if (n <= 0 || n > n2 - 4 || n < n2 - 5) {
            throw new RuntimeException("missng type type suffix for image  file name '" + string3 + "'");
        }
        boolean bl = false;
        String string5 = string3.substring(n);
        String string6 = string3.substring(0, n);
        boolean bl2 = string3.charAt(n - 1) == 'r';
        if (bl2) {
            string6 = string3.substring(0, --n);
            pictureInfo.large = pictureInfo.original;
        } else if (string2.length() != 0) {
            path = Path.valueOf((Object)(string6 + 'r' + string5));
            if (path.exists()) {
                pictureInfo.large = ImageInfo.readMetadata(path);
            } else if (autoScale) {
                String string7;
                if (string2.equals("left")) {
                    string7 = "90";
                } else if (string2.equals("right")) {
                    string7 = "270";
                } else {
                    throw new Error("unknown rotation " + string2 + " f0r " + string);
                }
                System.err.println("rotating " + string3 + " by " + string7 + " yielding " + path);
                String[] stringArray = new String[]{"/bin/sh", "-c", "jpegtran -rotate " + string7 + " -trim " + string3 + ">" + path};
                Process process = Runtime.getRuntime().exec(stringArray);
                int n3 = process.waitFor();
                if (n3 != 0) {
                    System.err.println("Unexpected jpegtran exitCode:" + n3);
                }
                pictureInfo.large = ImageInfo.readMetadata(path);
                bl = true;
            } else {
                System.err.println("rotated file " + path + " missing");
                pictureInfo.large = pictureInfo.original;
            }
        } else {
            pictureInfo.large = pictureInfo.original;
        }
        path = pictureInfo.large.filename;
        pictureInfo.thumbnail = PictureInfo.forceReadMetadata(string6 + 't' + string5, path, 240, bl);
        if (pictureInfo.large.width <= 740 && pictureInfo.large.height <= 740) {
            pictureInfo.medium = pictureInfo.large;
            pictureInfo.large = null;
        } else {
            pictureInfo.medium = PictureInfo.forceReadMetadata(string6 + 'p' + string5, path, 740, bl);
        }
        return pictureInfo;
    }

    static ImageInfo forceReadMetadata(String string, Path path, int n, boolean bl) throws Throwable {
        Path path2 = Path.valueOf((Object)string);
        if (bl || !path2.exists()) {
            if (!autoScale) {
                return null;
            }
            System.err.println("scaling " + path + " to " + string + " maxSize:" + n);
            Thumbnail.createThumbnail(path, path2, n);
        }
        return ImageInfo.readMetadata(path2);
    }

    boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public ImageInfo findImageInfo(Path path) {
        if (this.original != null && path.equals(this.original.filename)) {
            return this.original;
        }
        if (this.large != null && path.equals(this.large.filename)) {
            return this.large;
        }
        if (this.medium != null && path.equals(this.medium.filename)) {
            return this.medium;
        }
        if (this.thumbnail != null && path.equals(this.thumbnail.filename)) {
            return this.thumbnail;
        }
        return null;
    }

    public ImageInfo findScaledImage(String string) {
        if (string == null || string.length() == 0) {
            return this.original;
        }
        if (string.charAt(0) == 'o') {
            return this.original;
        }
        if (string.charAt(0) == 'l') {
            return this.large;
        }
        if (string.charAt(0) == 't') {
            return this.thumbnail;
        }
        if (string.charAt(0) == 'm' || string.charAt(0) == 'p') {
            return this.medium;
        }
        return null;
    }

    public boolean getScaledExists(String string) {
        return this.findScaledImage(string) != null;
    }

    public Path getScaledFile(String string) {
        return this.findScaledImage((String)string).filename;
    }

    public int getScaledWidth(String string) {
        return this.findScaledImage((String)string).width;
    }

    public int getScaledHeight(String string) {
        return this.findScaledImage((String)string).height;
    }

    public int getWidthFor(Path path) {
        return this.findImageInfo((Path)path).width;
    }

    public int getHeightFor(Path path) {
        return this.findImageInfo((Path)path).height;
    }

    public String getSizeDescription(Path path) {
        StringBuffer stringBuffer = new StringBuffer();
        ImageInfo imageInfo = this.findImageInfo(path);
        if (imageInfo != null) {
            stringBuffer.append(" (");
            stringBuffer.append(imageInfo.width);
            stringBuffer.append('x');
            stringBuffer.append(imageInfo.height);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getImageDescription() throws Throwable {
        Path path;
        char c;
        String string;
        int n;
        ImageInfo imageInfo;
        ImageInfo imageInfo2 = this.original != null ? this.original : (this.large != null ? this.large : (this.medium != null ? this.medium : (imageInfo = this.thumbnail != null ? this.thumbnail : null)));
        if (imageInfo != this.original && (n = (string = imageInfo.filename.toString()).length()) > 5 && ((c = string.charAt(n - 5)) == 'r' || c == 'p' || c == 't') && (path = Path.valueOf((Object)(string = string.substring(0, n - 5) + ".jpg"))).exists()) {
            this.original = imageInfo = ImageInfo.readMetadata(path);
        }
        return imageInfo.getCommonValues();
    }
}

