<!-- This Source Code Form is subject to the terms of the Mozilla Public
   - License, v. 2.0. If a copy of the MPL was not distributed with this
   - file, You can obtain one at http://mozilla.org/MPL/2.0/. -->

# The Program ID #

The Program ID is a unique identifier for your add-on. When you package your
add-on for distribution using `cfx xpi`, it will become the
[ID field in the add-on's Install Manifest](https://developer.mozilla.org/en/install.rdf#id).

The ID is used for a variety
of purposes. For example: [addons.mozilla.org](http://addons.mozilla.org) uses
it to distinguish between new add-ons and updates to existing add-ons, and the
[`simple-storage`](modules/sdk/simple-storage.html) module uses it
to figure out which stored data belongs to which add-on.

It is read from the `id` key in your add-on's [`package.json`](dev-guide/package-spec.html) file.
`cfx init` does not create this key, so if you don't set it yourself, the
first time you execute `cfx run` or `cfx xpi`, then `cfx` will create an
ID for you, and will show a message like this:

<pre>
  No 'id' in package.json: creating a new ID for you.
  package.json modified: please re-run 'cfx run'
</pre>

The ID generated by `cfx` in this way is a randomly-generated string, but
you can define your own ID by editing the `package.json` file
directly. In particular, you can use the `extensionname@example.org` format
described in the
[Install Manifest documentation](https://developer.mozilla.org/en/install.rdf#id).
However, you can't use the
[GUID-style](https://developer.mozilla.org/en/Generating_GUIDs) format.
