/* stats.h

   written by Don Robert Maszle
   24 August 1992
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.stats.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:15:06
      Author:  @a
   -- SCCS  ---------

   Statistical routines.

   The macro IS_MISSING(x) can be redefined for the particular
   convention in use for representing missing data.
   
   This is set up as a macro, instead of merely a value, to accomodate
   conventions such as NaN which cannot be used in comparisons.
*/

    /*** Define a convention for dealing with missing data.
     *   Be careful of side effects!  Keep quantities in ()s.
     *
     *   Current definition is:
     *     because our scalars of interest should be non-zero.
     *
     */

#define IS_MISSING(x) ((x) < 0.0)

    /*** Prototypes for statistical routines.  ********************
     *   Please add to these.
     */

double Cov (register int n, register double *x, register double *y,
	    double _xbar, double pybar);

void   ElemSqr (register int n, register double *x, register double *x2);

double Mean (register int n, register double *x);

double SigDigitRound (double x, int n);

double Var (register n, register double *x, double _xbar);
