%{
/*
 * Copyright (C) 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

/*
  This scanner for Perl was written by
  Alain Barbet <alian@alianwebserver.com>
*/

static int lineno = 1 ; /* number of scanned lines */
//char linebuf[1024] ; /* current code line in the source */
//int tokenpos = 0 ; /* current token position in the current line */

//#include "tags.h"
//#include "tokens.h"
//#include "colors.h"

#include "genfun.h"

%}
%option prefix="perl_scanner_"
%option noyywrap


nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>
pod (head1|head2|item)

keyword1 (chomp|chop|chr|crypt|hex|index|lc|lcfirst|length|oct|ord|pack|q|qq|reverse|rindex|sprintf|substr|tr|uc|ucfirst|m|s|qw)

keyword2 (abs|atan2|cos|exp|hex|int|log|oct|rand|sin|sqrt|srand|my|local|our)
keyword3 (delete|each|exists|keys|values|pack|read|syscall|sysread|syswrite|unpack|vec)

keyword4 (undef|unless|return|length|grep|sort|caller|continue|dump|eval|exit|goto|last|next|redo|sub|wantarray)
keyword5 (pop|push|shift|splice|unshift|split|switch|join|defined|foreach|last)
keyword6 (chop|chomp|bless|dbmclose|dbmopen|ref|tie|tied|untie|while|next|map)
keyword7 (eq|die|cmp|lc|uc|and|do|if|else|elsif|for|use|require|package|import)

keyword8 (chdir|chmod|chown|chroot|fcntl|glob|ioctl|link|lstat|mkdir|open|opendir|readlink|rename|rmdir|stat|symlink|umask|unlink|utime)

keyword9 (binmode|close|closedir|dbmclose|dbmopen|die|eof|fileno|flock|format|getc|print|printf|read|readdir|rewinddir|seek|seekdir|select|syscall|sysread|sysseek|syswrite|tell|telldir|truncate|warn|write)

keyword10 (alarm|exec|fork|getpgrp|getppid|getpriority|kill|pipe|qx|setpgrp|setpriority|sleep|system|times|wait|waitpid)


keyword ({keyword1}|{keyword2}|{keyword3}|{keyword4}|{keyword5}|{keyword6}|{keyword7}|{keyword8}|{keyword9}|{keyword10})

symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
cbracket [\{\}]

funccall {IDE}/{wspace}*({templspec}){0,1}{wspace}*\(

%%

<INITIAL>"#" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another # during a comment we simply
      treat it as a ordinary string */
 }
<INITIAL>^={pod} { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
<INITIAL>^"=cut" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of pod doc */ }


<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>($[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>(@[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>(%[0-9a-zA-Z_]*) { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%
/*
void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
*/
/* vim:set ft=flex expandtab cindent tabstop=4 softtabstop=4 shiftwidth=4 textwidth=0: */
