# Bengali (bn) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                             | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | ১৯৮৭তম                                                      | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | ৫ম                                                          | Invalid Date             |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | ১৯৮৭তম                                                      | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | ৫ম                                                          | Invalid Date             |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ১ত্রৈ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ২ত্রৈ                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | ১ম ত্রৈমাসিক                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ২য় ত্রৈমাসিক                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | ১                                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ২                                                           | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ১ত্রৈ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ২ত্রৈ                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | ১ম ত্রৈমাসিক                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ২য় ত্রৈমাসিক                                                | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ৭ম                                                          | Invalid Date             |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | ফেব্রু                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | ফেব্রুয়ারি                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ফেব্রু                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ৭ম                                                          | Invalid Date             |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | ফেব্রু                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | ফেব্রুয়ারি                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ফেব্রু                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | জুলাই                                                       | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | ৪৯তম                                                        | Invalid Date             |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | ৪৮তম                                                        | Invalid Date             |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | ১১ই                                                         | Invalid Date             |
|                                 |              | 2019-02-28T12:13:14.015Z | ২৮শে                                                        | Invalid Date             |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | ৪২তম                                                        | Invalid Date             |
|                                 |              | 2019-12-31T12:13:14.015Z | ৩৬৫তম                                                       | Invalid Date             |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | সোমবার                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্রবার                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | সো                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শু                                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ৫ম                                                          | Invalid Date             |
|                                 | iii          | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | সোমবার                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্রবার                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | সো                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শু                                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ৬ষ্ঠ                                                        | Invalid Date             |
|                                 | eee          | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | সোমবার                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্রবার                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | সো                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শু                                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | ২য়                                                          | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ৬ষ্ঠ                                                        | Invalid Date             |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | সোমবার                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্রবার                                                    | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | সো                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শু                                                          | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | সোম                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | শুক্র                                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | পূ                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপ                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপ                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূ                                                          | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপরাহ্ন                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূর্বাহ্ন                                                   | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | পূ                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | অপ                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | অপ                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | পূ                                                          | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | সকাল                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | বিকাল                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | সন্ধ্যা                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | রাত                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | সকাল                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | বিকাল                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | সন্ধ্যা                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | রাত                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | সকাল                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | বিকাল                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | সন্ধ্যা                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | রাত                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | সকাল                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | বিকাল                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | সন্ধ্যা                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | রাত                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | সকাল                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | বিকাল                                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | সন্ধ্যা                                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | রাত                                                         | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | ১১তম                                                        | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ১১তম                                                        | Invalid Date             |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | ১১তম                                                        | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ২৩তম                                                        | Invalid Date             |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | ১১তম                                                        | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ১১তম                                                        | Invalid Date             |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | ১১তম                                                        | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | ২৩তম                                                        | Invalid Date             |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:55:14.015Z | ৫৫তম                                                        | Invalid Date             |
| Second                          | so           | 2019-01-01T12:13:01.015Z | ১ম                                                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:55.015Z | ৫৫তম                                                        | Invalid Date             |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 02/11/1987                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453                                                  | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | ফেব্রু 11, 1987                                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | মে 29, 1453                                                 | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | ফেব্রুয়ারি ১১ই, 1987                                        | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | মে ২৯শে, 1453                                               | Invalid Date             |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | বুধবার, ফেব্রুয়ারি ১১ই, 1987                                | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | রবিবার, মে ২৯শে, 1453                                       | Invalid Date             |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 অপরাহ্ন                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 অপরাহ্ন                                               | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 অপরাহ্ন                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 অপরাহ্ন                                            | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 অপরাহ্ন GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 অপরাহ্ন GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 অপরাহ্ন GMT+00:00                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 অপরাহ্ন GMT+00:00                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 02/11/1987, 12:13 অপরাহ্ন                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453, 11:59 অপরাহ্ন                                   | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | ফেব্রু 11, 1987, 12:13:14 অপরাহ্ন                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | মে 29, 1453, 11:59:59 অপরাহ্ন                               | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | ফেব্রুয়ারি ১১ই, 1987 12:13:14 অপরাহ্ন GMT+0 সময়             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | মে ২৯শে, 1453 11:59:59 অপরাহ্ন GMT+0 সময়                    | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | বুধবার, ফেব্রুয়ারি ১১ই, 1987 12:13:14 অপরাহ্ন GMT+00:00 সময় | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | রবিবার, মে ২৯শে, 1453 11:59:59 অপরাহ্ন GMT+00:00 সময়        | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `includeSeconds: true` | `addSuffix: true`      |
| ------------------------ | ------------- | ---------------------- | ---------------------- |
| 2006-01-01T00:00:00.000Z | প্রায় ৬ বছর   | প্রায় ৬ বছর            | প্রায় ৬ বছর এর মধ্যে   |
| 2005-01-01T00:00:00.000Z | প্রায় ৫ বছর   | প্রায় ৫ বছর            | প্রায় ৫ বছর এর মধ্যে   |
| 2004-01-01T00:00:00.000Z | প্রায় ৪ বছর   | প্রায় ৪ বছর            | প্রায় ৪ বছর এর মধ্যে   |
| 2003-01-01T00:00:00.000Z | প্রায় ৩ বছর   | প্রায় ৩ বছর            | প্রায় ৩ বছর এর মধ্যে   |
| 2002-01-01T00:00:00.000Z | প্রায় ২ বছর   | প্রায় ২ বছর            | প্রায় ২ বছর এর মধ্যে   |
| 2001-06-01T00:00:00.000Z | ১ বছরের বেশি  | ১ বছরের বেশি           | ১ বছরের বেশি এর মধ্যে  |
| 2001-02-01T00:00:00.000Z | প্রায় ১ বছর   | প্রায় ১ বছর            | প্রায় ১ বছর এর মধ্যে   |
| 2001-01-01T00:00:00.000Z | প্রায় ১ বছর   | প্রায় ১ বছর            | প্রায় ১ বছর এর মধ্যে   |
| 2000-06-01T00:00:00.000Z | ৫ মাস         | ৫ মাস                  | ৫ মাস এর মধ্যে         |
| 2000-03-01T00:00:00.000Z | ২ মাস         | ২ মাস                  | ২ মাস এর মধ্যে         |
| 2000-02-01T00:00:00.000Z | প্রায় ১ মাস   | প্রায় ১ মাস            | প্রায় ১ মাস এর মধ্যে   |
| 2000-01-15T00:00:00.000Z | ১৪ দিন        | ১৪ দিন                 | ১৪ দিন এর মধ্যে        |
| 2000-01-02T00:00:00.000Z | ১ দিন         | ১ দিন                  | ১ দিন এর মধ্যে         |
| 2000-01-01T06:00:00.000Z | প্রায় ৬ ঘন্টা | প্রায় ৬ ঘন্টা          | প্রায় ৬ ঘন্টা এর মধ্যে |
| 2000-01-01T01:00:00.000Z | প্রায় ১ ঘন্টা | প্রায় ১ ঘন্টা          | প্রায় ১ ঘন্টা এর মধ্যে |
| 2000-01-01T00:45:00.000Z | প্রায় ১ ঘন্টা | প্রায় ১ ঘন্টা          | প্রায় ১ ঘন্টা এর মধ্যে |
| 2000-01-01T00:30:00.000Z | ৩০ মিনিট      | ৩০ মিনিট               | ৩০ মিনিট এর মধ্যে      |
| 2000-01-01T00:15:00.000Z | ১৫ মিনিট      | ১৫ মিনিট               | ১৫ মিনিট এর মধ্যে      |
| 2000-01-01T00:01:00.000Z | ১ মিনিট       | ১ মিনিট                | ১ মিনিট এর মধ্যে       |
| 2000-01-01T00:00:25.000Z | প্রায় ১ মিনিট | আধ মিনিট               | প্রায় ১ মিনিট এর মধ্যে |
| 2000-01-01T00:00:15.000Z | প্রায় ১ মিনিট | প্রায় ২০ সেকেন্ড       | প্রায় ১ মিনিট এর মধ্যে |
| 2000-01-01T00:00:05.000Z | প্রায় ১ মিনিট | প্রায় ১০ সেকেন্ড       | প্রায় ১ মিনিট এর মধ্যে |
| 2000-01-01T00:00:00.000Z | প্রায় ১ মিনিট | প্রায় ৫ সেকেন্ড        | প্রায় ১ মিনিট আগে      |
| 1999-12-31T23:59:55.000Z | প্রায় ১ মিনিট | প্রায় ১০ সেকেন্ড       | প্রায় ১ মিনিট আগে      |
| 1999-12-31T23:59:45.000Z | প্রায় ১ মিনিট | প্রায় ২০ সেকেন্ড       | প্রায় ১ মিনিট আগে      |
| 1999-12-31T23:59:35.000Z | প্রায় ১ মিনিট | আধ মিনিট               | প্রায় ১ মিনিট আগে      |
| 1999-12-31T23:59:00.000Z | ১ মিনিট       | ১ মিনিট                | ১ মিনিট আগে            |
| 1999-12-31T23:45:00.000Z | ১৫ মিনিট      | ১৫ মিনিট               | ১৫ মিনিট আগে           |
| 1999-12-31T23:30:00.000Z | ৩০ মিনিট      | ৩০ মিনিট               | ৩০ মিনিট আগে           |
| 1999-12-31T23:15:00.000Z | প্রায় ১ ঘন্টা | প্রায় ১ ঘন্টা          | প্রায় ১ ঘন্টা আগে      |
| 1999-12-31T23:00:00.000Z | প্রায় ১ ঘন্টা | প্রায় ১ ঘন্টা          | প্রায় ১ ঘন্টা আগে      |
| 1999-12-31T18:00:00.000Z | প্রায় ৬ ঘন্টা | প্রায় ৬ ঘন্টা          | প্রায় ৬ ঘন্টা আগে      |
| 1999-12-30T00:00:00.000Z | ২ দিন         | ২ দিন                  | ২ দিন আগে              |
| 1999-12-15T00:00:00.000Z | ১৭ দিন        | ১৭ দিন                 | ১৭ দিন আগে             |
| 1999-12-01T00:00:00.000Z | প্রায় ১ মাস   | প্রায় ১ মাস            | প্রায় ১ মাস আগে        |
| 1999-11-01T00:00:00.000Z | ২ মাস         | ২ মাস                  | ২ মাস আগে              |
| 1999-06-01T00:00:00.000Z | ৭ মাস         | ৭ মাস                  | ৭ মাস আগে              |
| 1999-01-01T00:00:00.000Z | প্রায় ১ বছর   | প্রায় ১ বছর            | প্রায় ১ বছর আগে        |
| 1998-12-01T00:00:00.000Z | প্রায় ১ বছর   | প্রায় ১ বছর            | প্রায় ১ বছর আগে        |
| 1998-06-01T00:00:00.000Z | ১ বছরের বেশি  | ১ বছরের বেশি           | ১ বছরের বেশি আগে       |
| 1998-01-01T00:00:00.000Z | প্রায় ২ বছর   | প্রায় ২ বছর            | প্রায় ২ বছর আগে        |
| 1997-01-01T00:00:00.000Z | প্রায় ৩ বছর   | প্রায় ৩ বছর            | প্রায় ৩ বছর আগে        |
| 1996-01-01T00:00:00.000Z | প্রায় ৪ বছর   | প্রায় ৪ বছর            | প্রায় ৪ বছর আগে        |
| 1995-01-01T00:00:00.000Z | প্রায় ৫ বছর   | প্রায় ৫ বছর            | প্রায় ৫ বছর আগে        |
| 1994-01-01T00:00:00.000Z | প্রায় ৬ বছর   | প্রায় ৬ বছর            | প্রায় ৬ বছর আগে        |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | ৬ বছর      | ৬ বছর এর মধ্যে      | ৫২৬০৮ ঘন্টা                    |
| 2005-01-01T00:00:00.000Z | ৫ বছর      | ৫ বছর এর মধ্যে      | ৪৩৮৪৮ ঘন্টা                    |
| 2004-01-01T00:00:00.000Z | ৪ বছর      | ৪ বছর এর মধ্যে      | ৩৫০৬৪ ঘন্টা                    |
| 2003-01-01T00:00:00.000Z | ৩ বছর      | ৩ বছর এর মধ্যে      | ২৬৩০৪ ঘন্টা                    |
| 2002-01-01T00:00:00.000Z | ২ বছর      | ২ বছর এর মধ্যে      | ১৭৫৪৪ ঘন্টা                    |
| 2001-06-01T00:00:00.000Z | ১ বছর      | ১ বছর এর মধ্যে      | ১২৪০৮ ঘন্টা                    |
| 2001-02-01T00:00:00.000Z | ১ বছর      | ১ বছর এর মধ্যে      | ৯৫২৮ ঘন্টা                     |
| 2001-01-01T00:00:00.000Z | ১ বছর      | ১ বছর এর মধ্যে      | ৮৭৮৪ ঘন্টা                     |
| 2000-06-01T00:00:00.000Z | ৫ মাস      | ৫ মাস এর মধ্যে      | ৩৬৪৮ ঘন্টা                     |
| 2000-03-01T00:00:00.000Z | ২ মাস      | ২ মাস এর মধ্যে      | ১৪৪০ ঘন্টা                     |
| 2000-02-01T00:00:00.000Z | ১ মাস      | ১ মাস এর মধ্যে      | ৭৪৪ ঘন্টা                      |
| 2000-01-15T00:00:00.000Z | ১৪ দিন     | ১৪ দিন এর মধ্যে     | ৩৩৬ ঘন্টা                      |
| 2000-01-02T00:00:00.000Z | ১ দিন      | ১ দিন এর মধ্যে      | ২৪ ঘন্টা                       |
| 2000-01-01T06:00:00.000Z | ৬ ঘন্টা    | ৬ ঘন্টা এর মধ্যে    | ৬ ঘন্টা                        |
| 2000-01-01T01:00:00.000Z | ১ ঘন্টা    | ১ ঘন্টা এর মধ্যে    | ১ ঘন্টা                        |
| 2000-01-01T00:45:00.000Z | ৪৫ মিনিট   | ৪৫ মিনিট এর মধ্যে   | ১ ঘন্টা                        |
| 2000-01-01T00:30:00.000Z | ৩০ মিনিট   | ৩০ মিনিট এর মধ্যে   | ১ ঘন্টা                        |
| 2000-01-01T00:15:00.000Z | ১৫ মিনিট   | ১৫ মিনিট এর মধ্যে   | ০ ঘন্টা                        |
| 2000-01-01T00:01:00.000Z | ১ মিনিট    | ১ মিনিট এর মধ্যে    | ০ ঘন্টা                        |
| 2000-01-01T00:00:25.000Z | ২৫ সেকেন্ড | ২৫ সেকেন্ড এর মধ্যে | ০ ঘন্টা                        |
| 2000-01-01T00:00:15.000Z | ১৫ সেকেন্ড | ১৫ সেকেন্ড এর মধ্যে | ০ ঘন্টা                        |
| 2000-01-01T00:00:05.000Z | ৫ সেকেন্ড  | ৫ সেকেন্ড এর মধ্যে  | ০ ঘন্টা                        |
| 2000-01-01T00:00:00.000Z | ০ সেকেন্ড  | ০ সেকেন্ড আগে       | ০ ঘন্টা                        |
| 1999-12-31T23:59:55.000Z | ৫ সেকেন্ড  | ৫ সেকেন্ড আগে       | ০ ঘন্টা                        |
| 1999-12-31T23:59:45.000Z | ১৫ সেকেন্ড | ১৫ সেকেন্ড আগে      | ০ ঘন্টা                        |
| 1999-12-31T23:59:35.000Z | ২৫ সেকেন্ড | ২৫ সেকেন্ড আগে      | ০ ঘন্টা                        |
| 1999-12-31T23:59:00.000Z | ১ মিনিট    | ১ মিনিট আগে         | ০ ঘন্টা                        |
| 1999-12-31T23:45:00.000Z | ১৫ মিনিট   | ১৫ মিনিট আগে        | ০ ঘন্টা                        |
| 1999-12-31T23:30:00.000Z | ৩০ মিনিট   | ৩০ মিনিট আগে        | ১ ঘন্টা                        |
| 1999-12-31T23:15:00.000Z | ৪৫ মিনিট   | ৪৫ মিনিট আগে        | ১ ঘন্টা                        |
| 1999-12-31T23:00:00.000Z | ১ ঘন্টা    | ১ ঘন্টা আগে         | ১ ঘন্টা                        |
| 1999-12-31T18:00:00.000Z | ৬ ঘন্টা    | ৬ ঘন্টা আগে         | ৬ ঘন্টা                        |
| 1999-12-30T00:00:00.000Z | ২ দিন      | ২ দিন আগে           | ৪৮ ঘন্টা                       |
| 1999-12-15T00:00:00.000Z | ১৭ দিন     | ১৭ দিন আগে          | ৪০৮ ঘন্টা                      |
| 1999-12-01T00:00:00.000Z | ১ মাস      | ১ মাস আগে           | ৭৪৪ ঘন্টা                      |
| 1999-11-01T00:00:00.000Z | ২ মাস      | ২ মাস আগে           | ১৪৬৪ ঘন্টা                     |
| 1999-06-01T00:00:00.000Z | ৭ মাস      | ৭ মাস আগে           | ৫১৩৬ ঘন্টা                     |
| 1999-01-01T00:00:00.000Z | ১ বছর      | ১ বছর আগে           | ৮৭৬০ ঘন্টা                     |
| 1998-12-01T00:00:00.000Z | ১ বছর      | ১ বছর আগে           | ৯৫০৪ ঘন্টা                     |
| 1998-06-01T00:00:00.000Z | ২ বছর      | ২ বছর আগে           | ১৩৮৯৬ ঘন্টা                    |
| 1998-01-01T00:00:00.000Z | ২ বছর      | ২ বছর আগে           | ১৭৫২০ ঘন্টা                    |
| 1997-01-01T00:00:00.000Z | ৩ বছর      | ৩ বছর আগে           | ২৬২৮০ ঘন্টা                    |
| 1996-01-01T00:00:00.000Z | ৪ বছর      | ৪ বছর আগে           | ৩৫০৬৪ ঘন্টা                    |
| 1995-01-01T00:00:00.000Z | ৫ বছর      | ৫ বছর আগে           | ৪৩৮২৪ ঘন্টা                    |
| 1994-01-01T00:00:00.000Z | ৬ বছর      | ৬ বছর আগে           | ৫২৫৮৪ ঘন্টা                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                        |
| ------------------------ | ----------------------------- |
| 2000-01-10T00:00:00.000Z | 01/10/2000                    |
| 2000-01-05T00:00:00.000Z | বুধবার সময় 12:00 পূর্বাহ্ন    |
| 2000-01-02T00:00:00.000Z | আগামীকাল সময় 12:00 পূর্বাহ্ন  |
| 2000-01-01T00:00:00.000Z | আজ সময় 12:00 পূর্বাহ্ন        |
| 1999-12-31T00:00:00.000Z | গতকাল সময় 12:00 পূর্বাহ্ন     |
| 1999-12-27T00:00:00.000Z | গত সোমবার সময় 12:00 পূর্বাহ্ন |
| 1999-12-21T00:00:00.000Z | 12/21/1999                    |
