/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
export interface StringsType {
  // X-Domain or 'messages'
  domain: string;
  lang: string;
  completeness: number;
  plural_forms: string;
  locale_data: {
    messages: Record<string, unknown>;
  };
}
export const strings: Record<string, StringsType> = {};

strings["it"] = {
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=n != 1;",
        lang: "it",
      },
    }
  },
  domain: "messages",
  plural_forms: "nplurals=2; plural=n != 1;",
  lang: "it",
  completeness: 14,
};

strings["es"] = {
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=n != 1;",
        lang: "es",
      },
    }
  },
  domain: "messages",
  plural_forms: "nplurals=2; plural=n != 1;",
  lang: "es",
  completeness: 100,
};

strings["en"] = {
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=n != 1;",
        lang: "en",
      },
    }
  },
  domain: "messages",
  plural_forms: "nplurals=2; plural=(n != 1);",
  lang: "en",
  completeness: 100,
};

strings["de"] = {
  locale_data: {
    messages: {
      "": {
        domain: "messages",
        plural_forms: "nplurals=2; plural=n != 1;",
        lang: "de",
      },
    }
  },
  domain: "messages",
  plural_forms: "nplurals=2; plural=n != 1;",
  lang: "de",
  completeness: 4,
};
