#ifndef WATCHDOG_H
#define WATCHDOG_H

/* 
   watchdog.H
   include file for xlogmaster background status checks
*/


/*{{{  Variables  */
// GTK based:




// others:
/* Class 0 filters are filters that apply at display-time */
gint class0_filters[] = {RAISE,LOWER,HIDE,-1};
/* Class 1 filters are filters that apply "during background"
   and require to keep the logfile open even if it isn't being
   watched at the moment */
gint class1_filters[] = {ALERT,NOTICE,UNICONIFY,EXECUTE,-1};


/*}}}*/

/* Subroutines: */

/*{{{  Logfile handling  */
void activate();
void deactivate();
static int tail_interrupt(gpointer);
static int cat_interrupt(gpointer);
/*}}}*/

/*{{{  shared routines  */
int reopen_logfile(int);
/*}}}*/

/*{{{  Watchdog  */
void start_watchdog();
void stop_watchdog();
static int watchdog_interrupt(gpointer);
static void append_text(char*, long);
static void replace_text(char*, long);
static void watchdog_file_error(gint);
/*}}}*/

#endif /* WATCHDOG_H */
