/* ,file-id archive://[lord]/400/vu/./str.c/1998-05-18
*/
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



#include "str.h"



unsigned long
strnhash (char * chr, int len)
{
  unsigned long result;

  result = 0;

  while (len--)
    {
      result = *chr + (result << 3) + (result >> (8 * sizeof (result) - 3));
      ++chr;
    }
  return result;
}



int
strcmp_prefix (char * prefix, char * s)
{
  while (*prefix)
    {
      if (*s < *prefix)
	return 1;
      else if (*s > *prefix)
	return -1;
      else
	++prefix, ++s;
    }
  return 0;
}


#if 0
static int
strlen (char * x)
{
  int q;
  q = 0;
  while (*x)
    ++x, ++q;
  return q;
}
#endif

char *
nindex (unsigned char * s, int n, int c)
{
  while (n)
    {
      if (*s == c)
	return s;
      ++s;
      --n;
    }
  return 0;
}

char *
nrindex (unsigned char * s, int n, int c)
{
  s += n - 1;
  while (n)
    {
      if (*s == c)
	return s;
      --s;
      --n;
    }
  return 0;
}

