/* drift.h -- This file is part of Archimedes release 0.0.9.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs/Germanium
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method. It is now able to simulate applied
   magnetic fields along with self consistent Faraday equation.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 06 sep.2004, Siracusa, J.M.Sellier
// Last modif. : 07 Sep.2007, Siracusa, J.M.Sellier
// ######################################################

// calculation of drift process

void
drift(real tau)
{
 int i,j;
 int i1,j1;
 int i2,j2;
 real ix,iy;
// real fx,fy;
 real lx,ly;
 real dkx,dky,hmt,ksquared,gk,thesquareroot;
 real vx,vy;

 if(IV==9) return;

 i=(int)(X/dx)+1;
 j=(int)(Y/dy)+1;
 if(i>=nx) i=nx;
 if(j>=ny) j=ny;
 i1=i;
 j1=j;
 
// Valid for every material
 vx=KX*HM[i_dom[i][j]][IV]/thesquareroot;
 vy=KY*HM[i_dom[i][j]][IV]/thesquareroot;
 dkx=-QH*(E[i][j][0]+vy*B[i][j])*tau;
 dky=-QH*(E[i][j][1]-vx*B[i][j])*tau;

// Electron drift process
 hmt=HM[i_dom[i][j]][IV]*tau;
 ksquared=KX*KX+KY*KY+KZ*KZ;
 gk=HHM[i_dom[i][j]][IV]*ksquared;
 thesquareroot=sqrt(1.+4.*alphaK[i_dom[i][j]][IV]*gk);
// Second order Runge-Kutta method
 ix=X; iy=Y;
 X+=hmt*(KX+0.5*dkx)/thesquareroot;
 Y+=hmt*(KY+0.5*dky)/thesquareroot;
// fx=X; fy=Y;
 KX+=dkx;
 KY+=dky;

// check if some particles are out of the device
 i=(int)(X/dx)+1;
 j=(int)(Y/dy)+1;
 if(i>=nx) i=nx;
 if(j>=ny) j=ny;
 i2=i;
 j2=j; 

if(i_dom[i1][j1]!=i_dom[i2][j2]){
 double k1,k2,T,R;
 double energy;
//printf("%d %d %d %d\n",i1,j1,i2,j2);
// calculates the particle energy
 ksquared=KX*KX+KY*KY+KZ*KZ;
 thesquareroot=sqrt(1.+4.*alphaK[i_dom[i1][j1]][IV]*HHM[i_dom[i1][j1]][IV]*ksquared);
 energy=(thesquareroot-1.)/(2.*alphaK[i_dom[i1][j1]][IV]);
 if(IV==2) energy+=EG[i_dom[i1][j1]];
 energy*=Q; // <--- energy in Joule
// calculates the Transmission probability
 k1=sqrt(2.*MSTAR[i_dom[i1][j1]][IV]*M*energy)/HBAR;
 if(IV==2 && NOVALLEY[i_dom[i2][j2]]==1){
   if((energy+(EMIN[i_dom[i1][j1]][IV]-EMIN[i_dom[i2][j2]][1])*Q)<0.) goto reflection;
   k2=sqrt(2.*MSTAR[i_dom[i2][j2]][1]*M*
          (energy-(EMIN[i_dom[i1][j1]][IV]-EMIN[i_dom[i2][j2]][IV])*Q))/HBAR;
   }
 else{
   if((energy+(EMIN[i_dom[i1][j1]][IV]-EMIN[i_dom[i2][j2]][IV])*Q)<0.) goto reflection;
   k2=sqrt(2.*MSTAR[i_dom[i2][j2]][IV]*M*
          (energy+(EMIN[i_dom[i1][j1]][IV]-EMIN[i_dom[i2][j2]][IV])*Q))/HBAR;
 }
 if(IV==2 && NOVALLEY[i_dom[i2][j2]]==1){
    T=pow(2.*(k1/(MSTAR[i_dom[i1][j2]][IV]*M))
      /(k1/(MSTAR[i_dom[i1][j1]][IV]*M)+k2/(MSTAR[i_dom[i2][j2]][1]*M)),2.);
    R=pow((k1/(MSTAR[i_dom[i1][j1]][IV]*M)-k2/(MSTAR[i_dom[i2][j2]][1]*M))
      /(k1/(MSTAR[i_dom[i1][j1]][IV]*M)+k2/(MSTAR[i_dom[i2][j2]][1]*M)),2.);
 }
 else{
    T=pow(2.*(k1/(MSTAR[i_dom[i1][j1]][IV]*M))
      /(k1/(MSTAR[i_dom[i1][j1]][IV]*M)+k2/(MSTAR[i_dom[i2][j2]][IV]*M)),2.);
    R=pow((k1/(MSTAR[i_dom[i1][j1]][IV]*M)-k2/(MSTAR[i_dom[i2][j2]][IV]*M))
      /(k1/(MSTAR[i_dom[i1][j1]][IV]*M)+k2/(MSTAR[i_dom[i2][j2]][IV]*M)),2.);
 }
//     printf("k1 = %g     k2 = %g   R = %g  T = %g\n",k1,k2,R*R/(R*R+T*T),T*T/(R*R+T*T));
 if(rnd()<R*R/(R*R+T*T)) goto reflection;
}

 goto boundaries;

// ---reflection---
 reflection:
 lx=dx*0.5*((real)(i1+i2));
 ly=dy*0.5*((real)(j1+j2));
 X=lx-(X-lx);
 Y=ly-(Y-ly);
// X=ix;
// Y=iy;
 KX=-KX;
 KY=-KY;

 boundaries:
// Generic boundary conditions for the super-particles
// ===================================================

// left edge
// =========
// ---Insulator---
 if(X<=0. && EDGE[3][j][0]==0){
  X=-X;
  KX=-KX;
  return;
 }
// ---Schottky or ohmic contact---
 else if(X<=0. && (EDGE[3][j][0]==1 || EDGE[3][j][0]==2)){
   IV=9;
   return;
 }
// right edge
// ==========
// ---Insulator---
 if(X>=LX && EDGE[1][j][0]==0){
  X=LX-(X-LX);
  KX=-KX;
  return;
 }
// ---Schottky or ohmic contact---
 else if(X>=LX && (EDGE[1][j][0]==1 || EDGE[1][j][0]==2)){
   IV=9;
   return;
 }
// bottom edge
// ===========
// ---Insulator---
 if(Y<=0. && EDGE[0][i][0]==0){
  Y=-Y;
  KY=-KY;
  return;
 }
// ---Schottky or ohmic contact---
 else if(Y<=0. && (EDGE[0][i][0]==1 || EDGE[0][i][0]==2)){
   IV=9;
   return;
 }
// upper edge
// ==========
// ---Insulator---
 if(Y>=LY && EDGE[2][i][0]==0){
  Y=LY-(Y-LY);
  KY=-KY;
  return;
 }
// ---Schottky or ohmic contact---
 else if(Y>=LY && (EDGE[2][i][0]==1 || EDGE[2][i][0]==2)){
   IV=9;
   return;
 }
/*
// vacuum rectangle
// ================
 if(VACUUMFLAG==1){
   if((VACUUMXI<=X && X<=VACUUMXF) &&
      (VACUUMYI<=Y && Y<=VACUUMYF)){
//printf("%g %g %g %g %g %g\n",ix,iy,VACUUMXI,VACUUMYI,VACUUMXF,VACUUMYF);
// left edge of vacuum rectangle
// =============================
// reflection on the insulator edge of the vacuum rectangle
     if(ix<=VACUUMXI){
       if(VACUUMLEFT==0){
         X=VACUUMXI-(X-VACUUMXI);
         KX=-KX;
         return;
       }
// schottky contact on the vacuum rectangle edge
       if(VACUUMLEFT==1){
         IV=9;
         return;
       }
     }

// right edge of vacuum rectangle
// ==============================
// reflection on the insulator edge of the vacuum rectangle
     if(ix>=VACUUMXF){
       if(VACUUMRIGHT==0){
         X=VACUUMXF-(X-VACUUMXF);
         KX=-KX;
         return;
       }
// schottky contact on the vacuum rectangle edge
       if(VACUUMRIGHT==1){
         IV=9;
         return;
       }
     }

// bottom edge of vacuum rectangle
// ===============================
// reflection on the insulator edge of the vacuum rectangle
     if(iy<=VACUUMYI){
       if(VACUUMDOWN==0){
         Y=VACUUMYI-(Y-VACUUMYI);
         KY=-KY;
         return;
       }
// schottky contact on the vacuum rectangle edge
       if(VACUUMDOWN==1){
         IV=9;
         return;
       }
     }

// upper edge of vacuum rectangle
// ==============================
// reflection on the insulator edge of the vacuum rectangle
     if(iy>=VACUUMYF){
       if(VACUUMUP==0){
         Y=VACUUMYF-(Y-VACUUMYF);
         KY=-KY;
         return;
       }
// schottky contact on the vacuum rectangle edge
       if(VACUUMUP==1){
         IV=9;
         return;
       }
     }
   } // end of if-in the vacuum rectangle
 } // end of if-vacuumflag
*/
}

// ============================================================
