#! /bin/sh
# Copyright (C) 1998-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Minimal test of Java functionality.

required=javac
. ./defs || Exit 1

cat >>configure.ac <<'EOF'
AC_OUTPUT
EOF

cat > Makefile.am << 'END'
javadir = $(datadir)/java
dist_java_JAVA = a.java b.java
END

$ACLOCAL
$AUTOCONF
$AUTOMAKE

$EGREP '\.stamp|class' Makefile.in # For debugging.
grep '^all[-a-z]*:.*classjava\.stamp' Makefile.in
test `grep -c '^all[-a-z]*:.*classjava\.stamp' Makefile.in` -eq 1

cat >a.java <<EOF
class a
{
}
EOF

cat >b.java <<EOF
class b
{
}
EOF

./configure --prefix "`pwd`"
$MAKE distcheck
