// Copyright (C) 1999-2005 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.
//
// This exception applies only to the code released under the name GNU
// ccScript.  If you copy code from other releases into a copy of GNU
// ccScript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for GNU ccScript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.
//

#include "module.h"

using namespace ccscript3Database;
using namespace std;
using namespace ost;

Mutex SQLDatabase::locker;

SQLDatabase::SQLDatabase(Line *line) 
{
	name = ScriptCommand::findKeyword(line, "database");
	user = ScriptCommand::findKeyword(line, "user");
	if(!user)
		user = ScriptCommand::findKeyword(line, "username");
#ifndef	WIN32
	if(!user)
		user = Script::user;
#endif
	pass = ScriptCommand::findKeyword(line, "password");
	if(!pass)
		pass = ScriptCommand::findKeyword(line, "pass");
#ifndef	WIN32
	if(!pass)
		pass = Script::pass;
#endif
	slog.debug("odbc: registering database '%s'", name); 

	hdbc = NULL;
	count = 0;
	errmsg[0] = 0;
}

void SQLDatabase::leave(void)
{
	MutexLock lock(locker);

	if(!count || !hdbc)
		return;

	if(--count)
		return;

	SQLDisconnect(hdbc);
	SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
	hdbc = NULL;
}		

bool SQLDatabase::enter(void)
{
	long err;
        SQLCHAR stat[10];
	SQLSMALLINT mlen;

	MutexLock lock(locker);
	if(!hdbc)
	{
		count = 0;
		err = SQLAllocHandle(SQL_HANDLE_DBC, hODBC, &hdbc);
		if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
		{
			slog.error("odbc: %s: failed to create handle", name);
                	return false;
		}

        	SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER *)5, 0);
		err = SQLConnect(hdbc, (SQLCHAR *)name, SQL_NTS, (SQLCHAR *)user, SQL_NTS, (SQLCHAR *)pass, SQL_NTS);
		if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
                {
                        SQLGetDiagRec(SQL_HANDLE_DBC, hdbc, 1,
                                stat, &err, errmsg, sizeof(errmsg), &mlen);
			if(errmsg[0] == '[')
				slog.error((const char *)errmsg);
			else
				slog.error("odbc: %s: %s", name, errmsg);
                        SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
			hdbc = NULL;
			return false;
                }		
	}
	else
		++count;
	return true;
}
