/*	DVIDEF - Get Device and Volume Information Data Identifier Definitions	*/

#define DVI$_DEVCHAR 2
#define DVI$_DEVCLASS 4
#define DVI$_DEVTYPE 6
#define DVI$_DEVBUFSIZ 8
#define DVI$_DEVDEPEND 10
#define DVI$_UNIT 12
#define DVI$_PID 14
#define DVI$_OWNUIC 16
#define DVI$_VPROT 18
#define DVI$_ERRCNT 20
#define DVI$_OPCNT 22
#define DVI$_RECSIZ 24
#define DVI$_MAXBLOCK 26
#define DVI$_DEVDEPEND2 28
#define DVI$_REFCNT 30
#define DVI$_DEVNAM 32
#define DVI$_VOLNAM 34
#define DVI$_SECTORS 36
#define DVI$_TRACKS 38
#define DVI$_CYLINDERS 40
#define DVI$_FREEBLOCKS 42
#define DVI$_LOGVOLNAM 44
#define DVI$_VOLNUMBER 46
#define DVI$_VOLCOUNT 48
#define DVI$_ROOTDEVNAM 50
#define DVI$_NEXTDEVNAM 52
#define DVI$_TRANSCNT 54
#define DVI$_MOUNTCNT 56
#define DVI$_CLUSTER 58
#define DVI$_MAXFILES 60
#define DVI$_SERIALNUM 62
#define DVI$_ACPPID 64
#define DVI$_ACPTYPE 66

#define DVI$_CONCEALED 68               /* Device is a concealed device - BOOLEAN - 1 byte */
/*                                                                          */
/** THE FOLLOWING CODES ARE THE INDIVIDUAL BITS OF THE DEVCHAR LONGWORD     */
/*                                                                          */
#define DVI$_REC 70                     /* DEVICE RECORD ORIENTED           */
#define DVI$_CCL 72                     /* CARRIAGE CONTROL DEVICE          */
#define DVI$_TRM 74                     /* DEVICE IS A TERMINAL             */
#define DVI$_DIR 76                     /* DEVICE IS DIRECTORY STRUCTURED   */
#define DVI$_SDI 78                     /* DEVICE IS SINGLE DIRECTORY STRUCTURED  */
#define DVI$_SQD 80                     /* SEQUENTIAL BLOCK-ORIENTED DEVICE (I.E., MAGTAPE)  */
#define DVI$_SPL 82                     /* DEVICE BEING SPOOLED             */
#define DVI$_OPR 84                     /* DEVICE IS AN OPERATOR            */
#define DVI$_RCT 86                     /* DISK CONTAINS RCT (DEC STANDARD 166 DISK)  */
#define DVI$_NET 88                     /* NETWORK DEVICE                   */
#define DVI$_FOD 90                     /* FILES-ORIENTED DEVICE (I.E., DISK AND MT)  */
#define DVI$_DUA 92                     /* DEVICE IS DUAL PORTED            */
#define DVI$_SHR 94                     /* DEVICE SHAREABLE                 */
#define DVI$_GEN 96                     /* DEVICE IS A GENERIC DEVICE       */
#define DVI$_AVL 98                     /* DEVICE AVAILABLE FOR USE         */
#define DVI$_MNT 100                    /* DEVICE IS MOUNTED                */
#define DVI$_MBX 102                    /* DEVICE IS A MAILBOX              */
#define DVI$_DMT 104                    /* DEVICE MARKED FOR DISMOUNT       */
#define DVI$_ELG 106                    /* DEVICE HAS ERROR LOGGING ENABLED  */
#define DVI$_ALL 108                    /* DEVICE IS ALLOCATED              */
#define DVI$_FOR 110                    /* DEVICE IS MOUNTED FOREIGN (I.E., NON-FILE STRUCTURED)  */
#define DVI$_SWL 112                    /* DEVICE IS SOFTWARE WRITE LOCKED  */
#define DVI$_IDV 114                    /* DEVICE CAPABLE OF PROVIDING INPUT  */
#define DVI$_ODV 116                    /* DEVICE CAPABLE OF PROVIDING OUTPUT  */
#define DVI$_RND 118                    /* DEVICE ALLOWS RANDOM ACCESS      */
#define DVI$_RTM 120                    /* DEVICE IS REALTIME IN NATURE     */
#define DVI$_RCK 122                    /* DEVICE HAS READ CHECKING ENABLED  */
#define DVI$_WCK 124                    /* DEVICE HAS WRITE CHECKING ENABLED  */
/*                                                                          */
/**  THE FOLLOWING CODES ARE THE INDIVIDUAL BITS OF THE DEVDEPEND LONGWORD  */
/**  (AS DEFINED FOR TERMINALS: TTDEF IN STARDEFQZ.SDL)                     */
/*                                                                          */
#define DVI$_TT_PASSALL 126
#define DVI$_TT_NOECHO 128
#define DVI$_TT_NOTYPEAHD 130
#define DVI$_TT_ESCAPE 132
#define DVI$_TT_HOSTSYNC 134
#define DVI$_TT_TTSYNC 136
#define DVI$_TT_SCRIPT 138
#define DVI$_TT_LOWER 140
#define DVI$_TT_MECHTAB 142
#define DVI$_TT_WRAP 144
#define DVI$_TT_CRFILL 146
#define DVI$_TT_LFFILL 148
#define DVI$_TT_SCOPE 150
#define DVI$_TT_REMOTE 152
#define DVI$_TT_EIGHTBIT 154
#define DVI$_TT_MBXDSABL 156
#define DVI$_TT_NOBRDCST 158
#define DVI$_TT_READSYNC 160
#define DVI$_TT_MECHFORM 162
#define DVI$_TT_HALFDUP 164
#define DVI$_TT_MODEM 166
#define DVI$_TT_OPER 168
#define DVI$_TT_PAGE 170                /*                                  */
/**  THE FOLLOWING CODES ARE THE INDIVIDUAL BITS OF THE DEVDEPEND2 LONGWORD */
/**  (AS DEFINED FOR TERMINALS: TT2DEF IN STARDEFQZ.SDL)                    */
/*                                                                          */
#define DVI$_TT_LOCALECHO 172
#define DVI$_TT_AUTOBAUD 174
#define DVI$_TT_HANGUP 176
#define DVI$_TT_MODHANGUP 178
#define DVI$_TT_BRDCSTMBX 180
#define DVI$_TT_DMA 182
#define DVI$_TT_ALTYPEAHD 184
#define DVI$_TT_SETSPEED 186
#define DVI$_TT_DCL_MAILBX 188          /* TEMP DEFINITIONS FOR DCL SPAWN   */
#define DVI$_TT_EDITING 190
#define DVI$_TT_INSERT 192
#define DVI$_TT_FALLBACK 194
#define DVI$_TT_DIALUP 196
#define DVI$_TT_SECURE 198
#define DVI$_TT_DISCONNECT 200
#define DVI$_TT_PASTHRU 202
#define DVI$_TT_SIXEL 204
#define DVI$_TT_DRCS 206
#define DVI$_TT_PRINTER 208
#define DVI$_TT_APP_KEYPAD 210
#define DVI$_TT_SYSPWD 212
#define DVI$_TT_ANSICRT 214
#define DVI$_TT_REGIS 216
#define DVI$_TT_BLOCK 218
#define DVI$_TT_AVO 220
#define DVI$_TT_EDIT 222
#define DVI$_TT_DECCRT 224              /*                                  */
/**  THE FOLLOWING CODES ARE REGULAR ITEMS                                  */
/*                                                                          */
#define DVI$_STS 226                    /* STATUS LONGWORD                  */
#define DVI$_DEVSTS 228                 /* DEVICE STATUS WORD               */
#define DVI$_DEVCHAR2 230               /* Second device characteristics longword - VALUE - 4 bytes  */
#define DVI$_FULLDEVNAM 232             /* Fully qualified device name      */
#define DVI$_LOCKID 234                 /* Device lock id - VALUE - 4 bytes */
#define DVI$_ALLDEVNAM 236              /* Allocation class + device name   */
#define DVI$_VOLSETMEM 238              /* Volume set member                */
#define DVI$_DEVLOCKNAM 240             /* Device lock name                 */
/*                                                                          */
/** THE FOLLOWING CODES SUPPORT FEATURES OF DUAL-PATH AND SHADOW-SET DEVICES */
/*                                                                          */
#define DVI$_ALLOCLASS 242              /* Allocation class of host(s)      */
#define DVI$_ALT_HOST_AVAIL 244         /* Alternate host is active         */
#define DVI$_ALT_HOST_NAME 246          /* Name of host serving alternate path */
#define DVI$_ALT_HOST_TYPE 248          /* Type of alternate host           */
#define DVI$_HOST_AVAIL 250             /* Primary host is active           */
#define DVI$_HOST_COUNT 252             /* Number of paths to the device    */
#define DVI$_HOST_NAME 254              /* Name of host serving the primary path */
#define DVI$_HOST_TYPE 256              /* Type of primary host (today one of "V785", "V780", "V750" or "HS50") */
#define DVI$_REMOTE_DEVICE 258          /* Device is not connected to local node */
#define DVI$_SERVED_DEVICE 260          /* Device is served to the cluster  */
#define DVI$_SHDW_CATCHUP_COPYING 262   /* Catch-up copy is in progress     */
#define DVI$_SHDW_MASTER 264            /* Device is "virtual" master device for shadow set */
#define DVI$_SHDW_MASTER_NAME 266       /* Name of the "virtual" master device for a shadow set */
#define DVI$_SHDW_MEMBER 268            /* Device is one of the volumes making a shadow set */
#define DVI$_SHDW_MERGE_COPYING 270     /* Merge copy is in progress        */
#define DVI$_SHDW_NEXT_MBR_NAME 272     /* Name of the next device in shadow set */
/*                                                                          */
/**  THE FOLLOWING CODES ARE REGULAR ITEMS                                  */
/*                                                                          */
#define DVI$_TT_PHYDEVNAM 274           /* Terminal physical device name - STRING - 64 bytes */
#define DVI$_TT_DECCRT2 276             /* DEC_CRT level 2 part of devdepend2 longword for  */
/* terminals.                                                               */
#define DVI$_MEDIA_NAME 278             /* Decoded media name from UCB$L_MEDIA_ID field (ie. RK07 ) */
#define DVI$_MEDIA_TYPE 280             /* Decoded media type from UCB$L_MEDIA_ID field (ie. DM ) */
#define DVI$_MEDIA_ID 282               /* NONdecoded media id from UCB$L_MEDIA_ID */
/*                                                                          */
/** THE FOLLOWING CODES ARE CONTINGENCY ITEMS FOR SHADOW SUPPORT.  IF THEY  */
/** ARE NOT USED, THE NEXT RELEASE OF VMS CAN REUSE THESE POSITIONS FOR OTHER */
/** ITEMS.  IF THEY ARE USED, A SYNONYM WITH MORE MEANING SHOULD BE DEFINED. */
/*                                                                          */
#define DVI$_SHDW_SPARE_BIT_1 284       /* A spare boolean                  */
#define DVI$_SHDW_SPARE_BIT_2 286       /* A spare boolean                  */
#define DVI$_SHDW_SPARE_STRING_1 288    /* A spare character string         */
#define DVI$_SHDW_SPARE_STRING_2 290    /* A spare character string         */
#define DVI$_SHDW_SPARE_INTEGER_1 292   /* A spare longword integer         */
#define DVI$_SHDW_SPARE_INTEGER_2 294   /* A spare longword integer         */
/****	ADD NEW ITEM-CODES IMMEDIATELY BEFORE THIS COMMENT *****            */
/*                                                                          */
/* Define flag bits in the item code.                                       */
/*                                                                          */
#define DVI$M_SECONDARY 1
#define DVI$M_NOREDIRECT 32768
struct dvidef {
    unsigned dvi$v_secondary : 1;       /* Use secondary device characteristics */
    unsigned dvi$v_item_code : 10;      /* Space for item code              */
    unsigned dvi$v_fill_0 : 4;          /* Spare flags                      */
    unsigned dvi$v_noredirect : 1;      /* Don't redirect to virtual terminal */
    } ;
/*                                                                          */
/* Constant form of name for past compatibility.                            */
/*                                                                          */
#define DVI$C_SECONDARY 1
/*                                                                          */
/* The following ACP type codes are formally defined in $AQBDEF             */
/* These synonyms are available to user programs and they are               */
/* guaranteed to be consistent by ASSUME's in SYSGETDEV.  Additions         */
/* to the ACP type codes in $AQBDEF should be reflected here and            */
/* in the ASSUMES in SYSGETDEV.                                             */
/*                                                                          */
#define DVI$C_ACP_F11V1 1               /* FILES-11 STRUCTURE LEVEL 1       */
#define DVI$C_ACP_F11V2 2               /* FILES-11 STRUCTURE LEVEL 2       */
#define DVI$C_ACP_MTA 3                 /* MAGTAPE                          */
#define DVI$C_ACP_NET 4                 /* NETWORKS                         */
#define DVI$C_ACP_REM 5                 /* REMOTE I/O                       */
#define DVI$C_ACP_JNL 6                 /* JOURNAL                          */
