#!/usr/bin/perl -w # -*- mode: perl -*-

#     GIFT, a flexible content based image retrieval system.
#     Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

######################################################################

require 5.002;

package CXTVWriter;
use lib '/home/demo/gift-0.1.4e/../GIFTInstall/bin'; # for including CFeedbackClient
require Exporter;
@ISA=qw(Exporter
	CXMLTreeVisitor);
@EXPORT_OK= qw(new
	       startVisit
	       endVisit
	      );

use XML::Writer;

sub new(){
  my $class = shift;
  my $self = {};
  bless $self, $class;
  $self->initialize(@_);
  return $self;
}

sub initialize{
  my$self=shift;
  my $lOutHandle=shift;
  if(defined $lOutHandle){
    $self->{writer}=new XML::Writer( OUTPUT => $lOutHandle,
				     DATA_MODE => 1,
				     DATA_INDENT => 2);
  }else{
    $self->{writer}=new XML::Writer();
  }
  $self->{writer}->xmlDecl("UTF-8","yes");
#  $self->{writer}->doctype("mrml");
}

#########################################
#
# startVisit
#
# This is just for testing
#
# PARAMETERS: The startVisit function takes a tree node (i.e. a hash reference)
# as parameter. The parameter is provided by CGIFTLink::traverse 
#
# RETURNS:    nothing
#
sub startVisit( $ ){
  my $self=shift;
  my $lRoot=shift;

  if(defined($lRoot->{element})){
    $self->{writer}->startTag($lRoot->{element},(%{$lRoot->{attributes}}))
  }else{
    #print "TEXT NODE:{",$lRoot->{text},"}\n\n";
    $self->{writer}->characters($lRoot->{text});
  }
}
#########################################
#
# endVisit
#
# prints the end tag
#
# PARAMETERS: The endVisit function takes a tree node (i.e. a hash reference)
#    as parameter. The parameter is provided by CGIFTLink::traverse 
#
# RETURNS:    nothing
#
sub endVisit( $ ){
  my $self=shift;
  my $lRoot=shift;
  if(defined($lRoot->{element})){

    $self->{writer}->endTag($lRoot->{element});
  }
}

