#! /bin/sh
# Create initial database structure.
# Copyright (C) 2001 Milan Zamazal
# Copyright (C) 1999 Free Software Foundation, Inc.
# Contributed by Bozo Bob (manson@juniper.net).
# Further hacked by Milan Zamazal (pdm@zamazal.org).
#
# This file is part of GNU GNATS.  
# (GNNOUUUUUUUUU GNATS!  GNOUUUUUUUUU GNATS!  Doesn't that have a nice
# sound?  Especially if you say all the Gs?)
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_USER=xGNATS_USERx
DATABASES=xSYSCONFDIRx/gnats/databases
DATADIR=xSYSCONFDIRx/gnats/defaults
LIBEXECDIR=xLIBEXECDIRx

domkdir() {
    mkdir "$1" || { echo "Can't create directory $1, exiting"; exit 1 ; }
    chown "${GNATS_USER}" "$1"
}

docp() {
    cp $DATADIR/"$1" "$2" || { echo "Can't copy file $DATADIR/$1 to $2, exiting"; exit 1 ; }
    chown "${GNATS_USER}" "$2"
}

prog=mkdb
USAGE="Usage: $prog [--help] DATABASE-NAME"
while [ $# -gt 0 ]; do
  case "$1" in
    -*)  echo "$USAGE" ; exit 1 ;;
     *)  if [ -n "$database" ] ; then
	    echo "$USAGE" 1>&2 ; exit 1 ;
	 else
	    database="$1" ;
	 fi ;;
  esac
  shift
done

if [ -z "${database}" ]
then
    echo "$USAGE" 1>&2 ;
    exit 1;
fi

dbdir=`grep "^${database}:" $DATABASES | sed 's/^.*:\([^:]*\)$/\1/'`
if [ -z "${dbdir}" ]
then
  echo "$prog: No proper entry for \`${database}' in \`$DATABASES'."
  exit 1
fi

if [ -d "${dbdir}" ]
then
  echo "$prog: There's already a directory ${dbdir}, exiting" !>&2
  exit 1
fi

domkdir "${dbdir}"

domkdir "${dbdir}/gnats-adm"
domkdir "${dbdir}/gnats-adm/locks"
domkdir "${dbdir}/gnats-queue"
domkdir "${dbdir}/pending"

echo "Copying default files from ${DATADIR}"

docp categories "${dbdir}/gnats-adm/categories"
docp submitters "${dbdir}/gnats-adm/submitters"
docp responsible "${dbdir}/gnats-adm/responsible"
docp gnatsd.access "${dbdir}/gnats-adm/gnatsd.access"
chmod 600 "${dbdir}/gnats-adm/gnatsd.access"
docp addresses "${dbdir}/gnats-adm/addresses"
docp states "${dbdir}/gnats-adm/states"
docp classes "${dbdir}/gnats-adm/classes"
docp dbconfig "${dbdir}/gnats-adm/dbconfig"

$LIBEXECDIR/gnats/gen-index -d "${database}" -o "${dbdir}/gnats-adm/index"
