.\" Copyright (c) 1993 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH queue-pr 8 "December 1999" "GNATS @VERSION@" "GNATS Administration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
queue-pr \- incoming mail control for GNATS
.SH SYNOPSIS
.hy 0
.na
.TP 1i
.B queue-pr
[
.B \-q | \-\-queue
]
[
.B \-r | \-\-run
]
.br
[
.B \-f \fIfilename\fB | \-\-file=\fIfilename\fR
]
.br
[
.B \-d \fIdatabase\fB | \-\-database=\fIdatabase\fR
]
.ad b
.hy 1
.SH DESCRIPTION
.B `queue-pr -q' 
should run through a 
.BR pipe (2V)
via the mail 
.BR aliases (5)
mechanism to automatically place incoming bug reports in a queue 
directory for
.B GNATS.
.LP
Run
.B `queue-pr -r'
via
.BR cron (8)
to periodically empty the 
.B GNATS
queue, filing new bug reports in the database.
.LP
Always use one of [
.B \-q | \-\-queue
] or [
.B \-r | \-\-run
] (but not both), in each call to 
.B queue-pr.
These are mutually exclusive functions in order to avoid collisions.
.SH OPTIONS
.TP 1i
.B \-q, \-\-queue
Accept standard input as an incoming mail message, placing this message in
an incrementally numbered file in the database subdirectory \fBgnats-queue\fR
for future handling.
.TP
.B \-r, \-\-run
Redirect files from the database subdirectory \fBgnats-queue\fR to
.BR file-pr (8)
which files and creates index entries for each.
.TP
.B \-f \fIfilename\fR or \fB\-\-file=\fIfilename\fR
Treat
.I filename
as input rather than reading from standard input (used with the
.B \-\-queue
option).
.TP
.B \-d \fIdatabase\fR or \fB\-\-database=\fIdatabasename\fR
Used with the 
.B \-\-queue
or
.B \-\-run
options, use the database named
.I database
rather than the database \fIdefault\fR or the database specified by the
.B GNATSDB
environment variable.
.SH "ENVIRONMENT VARIABLES"
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
If \fBGNATSDB\fR is not set, the database named \fIdefault\fR is used.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (7),
.BR send-pr (1),
.BR query-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdb (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
