/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.auth;

import gnu.crypto.util.ExpirableObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Password
extends ExpirableObject {
    private final char[] password;
    private final byte[] bPassword;
    private boolean mIsDestroyed;

    public final synchronized char[] getPassword() {
        if (this.mIsDestroyed) {
            throw new IllegalStateException("Attempted destroyed password access.");
        }
        return this.password;
    }

    public final synchronized byte[] getBytes() {
        if (this.mIsDestroyed) {
            throw new IllegalStateException("Attempted destroyed password access.");
        }
        return this.bPassword;
    }

    protected final synchronized void doDestroy() {
        if (this.isDestroyed()) {
            return;
        }
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = '\u0000';
            ++i;
        }
        i = 0;
        while (i < this.bPassword.length) {
            this.bPassword[i] = 0;
            ++i;
        }
        this.mIsDestroyed = true;
    }

    public final synchronized boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    private final /* synthetic */ void this() {
        this.mIsDestroyed = false;
    }

    public Password(char[] password) {
        this(password, 0, password.length, 3600000L);
    }

    public Password(char[] password, long delay) {
        this(password, 0, password.length, delay);
    }

    public Password(char[] password, int offset, int length) {
        this(password, offset, length, 3600000L);
    }

    public Password(char[] password, int offset, int length, long delay) {
        super(delay);
        this.this();
        if (offset < 0 || length < 0 || offset + length > password.length) {
            throw new ArrayIndexOutOfBoundsException("off=" + offset + " length=" + length + " array.length=" + password.length);
        }
        this.password = new char[length];
        this.bPassword = new byte[length];
        int i = 0;
        int j = offset;
        while (i < length) {
            this.password[i] = password[j];
            this.bPassword[i] = (byte)(password[j] & 0x7F);
            ++i;
            ++j;
        }
    }

    public Password(byte[] password) {
        this(password, 0, password.length, 3600000L);
    }

    public Password(byte[] password, long delay) {
        this(password, 0, password.length, delay);
    }

    public Password(byte[] password, int offset, int length) {
        this(password, offset, length, 3600000L);
    }

    public Password(byte[] password, int offset, int length, long delay) {
        super(delay);
        this.this();
        if (offset < 0 || length < 0 || offset + length > password.length) {
            throw new ArrayIndexOutOfBoundsException("off=" + offset + " length=" + length + " array.length=" + password.length);
        }
        this.password = new char[length];
        this.bPassword = new byte[length];
        int i = 0;
        int j = offset;
        while (i < length) {
            this.password[i] = (char)password[j];
            this.bPassword[i] = password[j];
            ++i;
            ++j;
        }
    }
}

