/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.DERValue;
import gnu.crypto.der.DERWriter;
import gnu.crypto.der.OID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.util.ArrayList;

class GnuDSAPrivateKey
implements DSAPrivateKey {
    private byte[] encodedKey;
    BigInteger x;
    BigInteger p;
    BigInteger q;
    BigInteger g;

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArrayList<DERValue> pki = new ArrayList<DERValue>(3);
            pki.add(new DERValue(2, BigInteger.ZERO));
            ArrayList<DERValue> algId = new ArrayList<DERValue>(2);
            algId.add(new DERValue(6, new OID("1.2.840.10040.4.1")));
            ArrayList<DERValue> algParams = new ArrayList<DERValue>(3);
            algParams.add(new DERValue(2, this.p));
            algParams.add(new DERValue(2, this.q));
            algParams.add(new DERValue(2, this.g));
            algId.add(new DERValue(48, algParams));
            pki.add(new DERValue(4, this.x.toByteArray()));
            DERWriter.write(out, new DERValue(48, pki));
            this.encodedKey = out.toByteArray();
            return (byte[])this.encodedKey.clone();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public BigInteger getX() {
        return this.x;
    }

    public String toString() {
        return "GnuDSAPrivateKey: x=" + (this.x != null ? this.x.toString(16) : "null") + " p=" + (this.p != null ? this.p.toString(16) : "null") + " q=" + (this.q != null ? this.q.toString(16) : "null") + " g=" + (this.g != null ? this.g.toString(16) : "null");
    }

    public GnuDSAPrivateKey(BigInteger x, BigInteger p, BigInteger q, BigInteger g) {
        this.x = x;
        this.p = p;
        this.q = q;
        this.g = g;
    }
}

