/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;

class GnuRSAPrivateKey
implements RSAPrivateCrtKey {
    private final RSAPrivateCrtKeySpec spec;
    private byte[] encodedKey;

    public BigInteger getModulus() {
        return this.spec.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.spec.getPrivateExponent();
    }

    public BigInteger getCrtCoefficient() {
        return this.spec.getCrtCoefficient();
    }

    public BigInteger getPrimeExponentP() {
        return this.spec.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return this.spec.getPrimeExponentQ();
    }

    public BigInteger getPrimeP() {
        return this.spec.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return this.spec.getPrimeQ();
    }

    public BigInteger getPublicExponent() {
        return this.spec.getPublicExponent();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        ArrayList<DERValue> key = new ArrayList<DERValue>(9);
        key.add(new DERValue(2, BigInteger.ZERO));
        key.add(new DERValue(2, this.getModulus()));
        key.add(new DERValue(2, this.getPublicExponent()));
        key.add(new DERValue(2, this.getPrivateExponent()));
        key.add(new DERValue(2, this.getPrimeP()));
        key.add(new DERValue(2, this.getPrimeQ()));
        key.add(new DERValue(2, this.getPrimeExponentP()));
        key.add(new DERValue(2, this.getPrimeExponentQ()));
        key.add(new DERValue(2, this.getCrtCoefficient()));
        DERValue pk = new DERValue(48, key);
        ArrayList<DERValue> pki = new ArrayList<DERValue>(3);
        pki.add(new DERValue(2, BigInteger.ZERO));
        ArrayList<DERValue> alg = new ArrayList<DERValue>(2);
        alg.add(new DERValue(6, new OID("1.2.840.113549.1.1.1")));
        alg.add(new DERValue(5, null));
        pki.add(new DERValue(48, alg));
        pki.add(new DERValue(4, pk.getEncoded()));
        this.encodedKey = new DERValue(48, pki).getEncoded();
        return (byte[])this.encodedKey.clone();
    }

    public GnuRSAPrivateKey(RSAPrivateCrtKeySpec spec) {
        this.spec = spec;
    }
}

