/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define NO_NUTR 81

typedef struct Nutr_s {
	gchar *nutr_no;
	gchar *nutr_desc;
} Nutr_t;

typedef struct Food_Des_s {
	gchar *fd_no;
	gchar *gp_no;
	gchar *fd_desc;
} Food_Des_t;

typedef struct Msre_Desc_s {
	gchar *msre_no;
	gchar *msre_desc;
} Msre_Desc_t;

typedef struct Food_Group_s {
	gchar *gp_no;
	gchar *gp_desc;
} Food_Group_t;

typedef struct Food_Nutr_s {
	gchar *fd_no;
	gfloat value[NO_NUTR];
} Food_Nutr_t;

typedef struct Msre_Weight_s {
	gchar *fd_no;
	gchar *msre_no;
	gchar *msre_weight;
} Msre_Weight_t;

typedef struct Food_Msre_s {
	gchar *msre_no;
	gchar *msre_desc;
	gchar *msre_weight;
} Food_Msre_t;

typedef struct Food_s {
	Food_Des_t *desc;
	Food_Group_t *group;
	Food_Nutr_t *nutrs;
	gint no_msre;
	gint sel_msre;
	Food_Msre_t **msre;
} Food_t;

GList *
gnutr_create_food_glist( void);

GList *
gnutr_create_food_group_glist( void);

void 
gnutr_free_food_glist( GList **);

void 
gnutr_free_food_group_glist( GList **);

gchar *
gnutr_find_food_group_number( gchar *);

GList *
gnutr_ret_nutr_glist( void);

gint get_food_measure_num( Food_t *, gchar *);
