/* Copyright (C) 2022-2024 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */


package org.gprofng.mpmt.util.gui;

import org.gprofng.mpmt.AnLocale;
import org.gprofng.mpmt.Analyzer;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

class AnDialogOuterPanel extends javax.swing.JPanel {
  private AnDialog2 dialog;
  private JPanel customPanel;
  private String helpTag;
  private int auxGridy = 0;

  public AnDialogOuterPanel(final AnDialog2 dialog) {
    this.dialog = dialog;
    initComponents();
    helpButton.setVisible(false);
    helpButton.setEnabled(false);
    panel.setLayout(new BorderLayout());
    okButton.setText(AnLocale.getString("OK")); // NOI18N);
    //        okButton.setMnemonic(AnLocale.getString('O', "EXPORT_DIALOG_OK_MN")); // NOI18N);
    okButton.setToolTipText(AnLocale.getString("OK")); // NOI18N);
    okButton.addActionListener(
        new AbstractAction() {
          @Override
          public void actionPerformed(ActionEvent e) {
            dialog.setStatus(AnDialog2.Status.OK);
            dialog.setVisible(false);
          }
        });
    cancelButton.setText(AnLocale.getString("Cancel")); // NOI18N);
    //        cancelButton.setMnemonic(AnLocale.getString('C', "EXPORT_DIALOG_CANCEL_MN")); //
    // NOI18N);
    cancelButton.setToolTipText(AnLocale.getString("Cancel")); // NOI18N);
    cancelButton.addActionListener(
        new AbstractAction() {
          @Override
          public void actionPerformed(ActionEvent e) {
            dialog.setStatus(AnDialog2.Status.CANCEL);
            dialog.setVisible(false);
          }
        });
    helpButton.setText(AnLocale.getString("Help")); // NOI18N);
    helpButton.setMnemonic(AnLocale.getString('H', "EXPORT_DIALOG_HELP_MN")); // NOI18N);
    helpButton.setToolTipText(AnLocale.getString("Help")); // NOI18N);
    helpButton.addActionListener(
        new AbstractAction() {
          @Override
          public void actionPerformed(ActionEvent e) {
            Analyzer.showHelp(helpTag);
          }
        });

    dialog.getRootPane().setDefaultButton(okButton); // default action (Return key)
  }

  protected void setCustomPanel(JPanel customPanel) {
    this.customPanel = customPanel;
    panel.add(customPanel, BorderLayout.CENTER);
  }

  protected void setHelpTag(String helpTag) {
    this.helpTag = helpTag;
    helpButton.setVisible(helpTag != null);
  }

  protected JButton getOKButton() {
    return okButton;
  }

  protected JButton getCancelButton() {
    return cancelButton;
  }

  protected JButton getHelpButton() {
    return helpButton;
  }

  public void addAuxButton(JButton auxButton) {
    GridBagConstraints gridBagConstraints = new GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
    add(auxButton, gridBagConstraints);
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    panel = new javax.swing.JPanel();
    okButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();
    helpButton = new javax.swing.JButton();

    setLayout(new java.awt.GridBagLayout());

    javax.swing.GroupLayout panelLayout = new javax.swing.GroupLayout(panel);
    panel.setLayout(panelLayout);
    panelLayout.setHorizontalGroup(
        panelLayout
            .createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE));
    panelLayout.setVerticalGroup(
        panelLayout
            .createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 266, Short.MAX_VALUE));

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.gridwidth = 5;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.weighty = 1.0;
    add(panel, gridBagConstraints);

    okButton.setText("jButton1");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 2;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
    add(okButton, gridBagConstraints);

    cancelButton.setText("jButton2");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 3;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
    gridBagConstraints.insets = new java.awt.Insets(8, 4, 0, 0);
    add(cancelButton, gridBagConstraints);

    helpButton.setText("jButton3");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 4;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
    gridBagConstraints.insets = new java.awt.Insets(8, 4, 0, 0);
    add(helpButton, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JButton helpButton;
  private javax.swing.JButton okButton;
  private javax.swing.JPanel panel;
  // End of variables declaration//GEN-END:variables
}
