/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : line-edit library                                               */
/* File  : test_linedit.c                                                  */
/* Descr.: test file                                                       */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include "linedit.h"

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/


/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

/*-------------------------------------------------------------------------*/
/* INTERRUPT_HANDLER                                                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void Interrupt_Handler(int sig)

{
 int       c;
 sigset_t  set;
 char      prefix[100];
 char     *str;
 int       nb,max_lg,is_last;


 printf("\nCatching signal:%d\n",sig);
 signal(sig,Interrupt_Handler);
 printf("e to exit - c to continue - C for completions:");
 fflush(stdout);

 sigemptyset(&set);
 sigaddset(&set,sig);
 sigprocmask(SIG_UNBLOCK,&set,NULL);

 c=LE_FGetc_No_Echo(0,1);
 printf("\n");

 if (c=='e')
    exit(0);

 if (c=='C')
    {
     printf("Enter a prefix:");
     fgets(prefix,sizeof(prefix),stdin);
     prefix[strlen(prefix)-1]='\0';
     if ((str=LE_Compl_Init_Match(prefix,&nb,&max_lg))==NULL)
         printf("no matching\n");
      else
	{
         printf("common=<%s> nb=%d max_lg=%d\n",str,nb,max_lg);
         while((str=LE_Compl_Find_Match(&is_last))!=NULL)
             printf("matching: <%s>\n",str);
	}
    }
}




/*-------------------------------------------------------------------------*/
/* MAIN                                                                    */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int main()

{
 char line[256];
 char *p;
 char sep[100];

#if 1
 signal(SIGINT,Interrupt_Handler);
 signal(SIGQUIT,Interrupt_Handler);
#endif

 sep[0]='\n';
 strcpy(sep+1,LE_Get_Separators());

 printf("enter lines (EOF to finish)\n");

 for(;;)
    {
#if 0
     printf("tempo to allow you to buffer some chars before the read\n");
     sleep(2);
#endif

#if 0
     printf("enter a line:");
     if (LE_Gets(line)==NULL)
#else
     if (LE_FGets(line,50,0,1,"enter a line:",1)==NULL)
#endif
         break;
     printf("Line:(%s) len:%d\n",line,strlen(line));
     for(p=line;(p=strtok(p,sep));p=NULL)
        {
         printf("adding word (%s) for completion\n",p);
         LE_Compl_Add_Word(strdup(p),strlen(p));
        }
    }

 return 0;
}


