/*
 * $Id: CompiledExpression.java,v 1.1.1.1 1998/05/11 18:43:02 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel;

/**
 * The superclass of every compiled expression.
 */
public abstract class CompiledExpression {
  
  /**
   * Evaluates the expression.
   * @param dynamic_lib the library of the objects, containing "dynamic" 
   *   functions. These objects should be exactly in the same order
   *   as corresponding dynamic library classes during the construction of 
   *   the library for compilation.
   * @return the result fo computation.
   * @exception Throwable if any runtime error have occured (i.e. division
   *          by 0)
   * @see gnu.jel.Evaluator#compile
   * @see gnu.jel.Library
   */
  public abstract Object evaluate(Object[] dynamic_lib) throws Throwable;
};
