/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.NFKC;
import gnu.inet.encoding.RFC3454;
import gnu.inet.encoding.StringprepException;

public class Stringprep {
    private static final char[] RFC3920_NODEPREP_PROHIBIT = new char[]{'\"', '&', '\'', '/', ':', '<', '>', '@'};

    public static String nameprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.nameprep(string, false);
    }

    public static String nameprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!bl && Stringprep.contains(stringBuffer, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(stringBuffer, RFC3454.B1);
        Stringprep.map(stringBuffer, RFC3454.B2search, RFC3454.B2replace);
        stringBuffer = new StringBuffer(NFKC.normalizeNFKC(stringBuffer.toString()));
        if (Stringprep.contains(stringBuffer, RFC3454.C12) || Stringprep.contains(stringBuffer, RFC3454.C22) || Stringprep.contains(stringBuffer, RFC3454.C3) || Stringprep.contains(stringBuffer, RFC3454.C4) || Stringprep.contains(stringBuffer, RFC3454.C5) || Stringprep.contains(stringBuffer, RFC3454.C6) || Stringprep.contains(stringBuffer, RFC3454.C7) || Stringprep.contains(stringBuffer, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = Stringprep.contains(stringBuffer, RFC3454.D1);
        boolean bl3 = Stringprep.contains(stringBuffer, RFC3454.D2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || Stringprep.contains(stringBuffer.charAt(0), RFC3454.D1) && Stringprep.contains(stringBuffer.charAt(stringBuffer.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuffer.toString();
    }

    public static String nodeprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.nodeprep(string, false);
    }

    public static String nodeprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!bl && Stringprep.contains(stringBuffer, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(stringBuffer, RFC3454.B1);
        Stringprep.map(stringBuffer, RFC3454.B2search, RFC3454.B2replace);
        stringBuffer = new StringBuffer(NFKC.normalizeNFKC(stringBuffer.toString()));
        if (Stringprep.contains(stringBuffer, RFC3454.C11) || Stringprep.contains(stringBuffer, RFC3454.C12) || Stringprep.contains(stringBuffer, RFC3454.C21) || Stringprep.contains(stringBuffer, RFC3454.C22) || Stringprep.contains(stringBuffer, RFC3454.C3) || Stringprep.contains(stringBuffer, RFC3454.C4) || Stringprep.contains(stringBuffer, RFC3454.C5) || Stringprep.contains(stringBuffer, RFC3454.C6) || Stringprep.contains(stringBuffer, RFC3454.C7) || Stringprep.contains(stringBuffer, RFC3454.C8) || Stringprep.contains(stringBuffer, RFC3920_NODEPREP_PROHIBIT)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = Stringprep.contains(stringBuffer, RFC3454.D1);
        boolean bl3 = Stringprep.contains(stringBuffer, RFC3454.D2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || Stringprep.contains(stringBuffer.charAt(0), RFC3454.D1) && Stringprep.contains(stringBuffer.charAt(stringBuffer.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuffer.toString();
    }

    public static String resourceprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.resourceprep(string, false);
    }

    public static String resourceprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!bl && Stringprep.contains(stringBuffer, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(stringBuffer, RFC3454.B1);
        stringBuffer = new StringBuffer(NFKC.normalizeNFKC(stringBuffer.toString()));
        if (Stringprep.contains(stringBuffer, RFC3454.C12) || Stringprep.contains(stringBuffer, RFC3454.C21) || Stringprep.contains(stringBuffer, RFC3454.C22) || Stringprep.contains(stringBuffer, RFC3454.C3) || Stringprep.contains(stringBuffer, RFC3454.C4) || Stringprep.contains(stringBuffer, RFC3454.C5) || Stringprep.contains(stringBuffer, RFC3454.C6) || Stringprep.contains(stringBuffer, RFC3454.C7) || Stringprep.contains(stringBuffer, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = Stringprep.contains(stringBuffer, RFC3454.D1);
        boolean bl3 = Stringprep.contains(stringBuffer, RFC3454.D2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || Stringprep.contains(stringBuffer.charAt(0), RFC3454.D1) && Stringprep.contains(stringBuffer.charAt(stringBuffer.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuffer.toString();
    }

    static boolean contains(StringBuffer stringBuffer, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (c == stringBuffer.charAt(n2)) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    static boolean contains(StringBuffer stringBuffer, char[][] cArray) {
        int n = 0;
        while (n < cArray.length) {
            int n2;
            char c;
            char[] cArray2 = cArray[n];
            if (1 == cArray2.length) {
                c = cArray2[0];
                n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (c == stringBuffer.charAt(n2)) {
                        return true;
                    }
                    ++n2;
                }
            } else if (2 == cArray2.length) {
                c = cArray2[0];
                n2 = cArray2[1];
                int n3 = 0;
                while (n3 < stringBuffer.length()) {
                    if (c <= stringBuffer.charAt(n3) && n2 >= stringBuffer.charAt(n3)) {
                        return true;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return false;
    }

    static boolean contains(char c, char[][] cArray) {
        int n = 0;
        while (n < cArray.length) {
            char[] cArray2 = cArray[n];
            if (1 == cArray2.length) {
                if (c == cArray2[0]) {
                    return true;
                }
            } else if (2 == cArray2.length) {
                char c2 = cArray2[0];
                char c3 = cArray2[1];
                if (c2 <= c && c3 >= c) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    static void filter(StringBuffer stringBuffer, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (c == stringBuffer.charAt(n2)) {
                    stringBuffer.deleteCharAt(n2);
                    continue;
                }
                ++n2;
            }
            ++n;
        }
    }

    static void filter(StringBuffer stringBuffer, char[][] cArray) {
        int n = 0;
        while (n < cArray.length) {
            int n2;
            char c;
            char[] cArray2 = cArray[n];
            if (1 == cArray2.length) {
                c = cArray2[0];
                n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (c == stringBuffer.charAt(n2)) {
                        stringBuffer.deleteCharAt(n2);
                        continue;
                    }
                    ++n2;
                }
            } else if (2 == cArray2.length) {
                c = cArray2[0];
                n2 = cArray2[1];
                int n3 = 0;
                while (n3 < stringBuffer.length()) {
                    if (c <= stringBuffer.charAt(n3) && n2 >= stringBuffer.charAt(n3)) {
                        stringBuffer.deleteCharAt(n3);
                        continue;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    static void map(StringBuffer stringBuffer, char[] cArray, String[] stringArray) {
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (c == stringBuffer.charAt(n2)) {
                    stringBuffer.deleteCharAt(n2);
                    if (stringArray[n] == null) continue;
                    stringBuffer.insert(n2, stringArray[n]);
                    n2 += stringArray[n].length() - 1;
                    continue;
                }
                ++n2;
            }
            ++n;
        }
    }
}

