/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */
	
const Request = require('request').Request;
const ss = require("simple-storage");
const notifications = require("notifications");
const tabs = require("tabs");

// current version.
var version = 45;

var notify = function () {
    notifications.notify({
			     title: "GNU LibreJS Update Available",
			     text: "An update for LibreJS is available. \nClick to visit GNU LibreJS project page.",
			     data: ss.storage.checkIn,
			     onClick: function (data) {
				 tabs.open('http://www.gnu.org/software/librejs/?' + ss.storage.checkIn);
			     }
			 });
    
};



var isUpdated = Request({

  url: "http://www.gnu.org/software/librejs/distribution/version/version.json?" + ss.storage.checkIn,
  onComplete: function (response) {
      // check again in three days.
      ss.storage.checkIn = (new Date().getTime() / 1000) + 259200;
      if (version < response.json.version) {
	  notify();
      }
  }
});



if (ss.storage.checkIn == undefined) {
    isUpdated.get();
}

else if ((new Date().getTime() / 1000) > ss.storage.checkIn) {
    isUpdated.get();
}

