/* logging.h: Structures and defines used in the Mhttpd logging system. */

/* Author: Brian J. Fox (bfox@ai.mit.edu) Tue Nov 14 19:14:52 1995.

   This file is part of <Meta-HTML>(tm), a system for the rapid deployment
   of Internet and Intranet applications via the use of the Meta-HTML
   language.

   Copyright (c) 1995, 1996, Brian J. Fox (bfox@ai.mit.edu).
   Copyright (c) 1996, Universal Access Inc. (http://www.ua.com).

   Meta-HTML is free software; you can redistribute it and/or modify
   it under the terms of the UAI Free Software License as published
   by Universal Access Inc.; either version 1, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   UAI Free Software License for more details.

   You should have received a copy of the UAI Free Software License
   along with this program; if you have not, you may obtain one by
   writing to:

   Universal Access Inc.
   129 El Paseo Court
   Santa Barbara, CA
   93101  */

#if !defined (_LOGGING_H_)
#define _LOGGING_H_ 1

#define log_ERROR   0
#define log_NOTIFY  1
#define log_ACCESS  2
#define log_DEBUG   3
#define log_REFERER 4
#define log_AGENT   5

typedef struct
{
  int which;			/* One of the above defines. */
  char *logfile;		/* Full path to the log file. */
} LOG_MAPPING;

extern LOG_MAPPING **mhttpd_logfiles;

extern void mhttpd_set_logfile (int which, char *name);
extern char *mhttpd_get_logfile (int which);
extern void mhttpd_log (int which, char *format, ...);
extern void mhttpd_access_log (char *name, char *format, ...);
extern void mhttpd_log_verbatim (int which, char *format, ...);
extern char *mhttpd_date_format (long ticks);
#endif /* !_LOGGING_H_ */
