/*  Motti -- a strategy game
    Copyright (C) 1999-2007 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <config.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#ifdef HAVE_STRING_H
# include <string.h>
#else
# include <strings.h>
#endif

#include "wrappers.h"

extern void
die (const char *msg, ...)
{
  va_list args;
  char fullmsg[256];	/* Should be enough for every message.  */
  va_start (args, msg);

  sprintf (fullmsg, "motti: %s\n", msg);
  vfprintf (stderr, fullmsg, args);
  va_end (args);
  exit (1);
}

extern void *
my_malloc (size)
     size_t size;
{
  void *ptr;
  ptr = malloc(size);
  if (ptr == NULL && size != 0)
    {
      die ("malloc error");
      exit (1);
    }
  return ptr;
}

extern void *
my_calloc (nmemb, size)
     size_t nmemb, size;
{
  void *ptr;
  ptr = calloc (nmemb, size);
  if (ptr == NULL && size != 0)
    {
      /* Function die uses my_malloc, so we can't use it here.  */
      fprintf (stderr, "motti: calloc error\n");
      exit (1);
    }
  return ptr;
}
