/* proxyknife -- customizable proxy hunter
 * Copyright (C) 2005-2006 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of proxyknife.
 * Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Proxyknife is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in proxyknife.h */
#include <proxyknife.h>
/* for open */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/* for dup2 */
#include <unistd.h>

/* for perror */
#include <errno.h>

/* strlen */
#include <string.h>

/* Global mutex */
pthread_mutex_t counter_mutex_in = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_out = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_create = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_malloc = PTHREAD_MUTEX_INITIALIZER;

/* these functions are defined in this file */
void INIT (int argc, char **argv);
void THREAD (void);
void END (void);

/* Set the limit on number of  threads */
enum
{ MAXTHREADS = 65535 };

int
main (int argc, char **argv)
{
  progname = argv[0];
           setlocale(LC_ALL,"");
           setlocale(LC_MESSAGES,"");
           bindtextdomain(PACKAGE,LOCALEDIR);
           textdomain(PACKAGE);

  INIT (argc,argv);
  THREAD ();
  END ();
  /* clean memory */
  xexit (EXIT_SUCCESS);
}

/* Read configuration file ,init global vars.
 * Open list file and output file.
 * Close buffering of STDIN ,STDOUT and STDERR */
void
INIT (int argc,char **argv)
{
  struct hostent *h;
  size_t len;

  /* init , used by END() */
  logfd = -1;

  mem_init ();
  READCONF (argc,argv);

  if ((test.httptestmethod != HTTP_CONNECT)
      && (test.httptestmethod != HTTP_GET))
    {
      fprintf (stderr, "%s: INIT:Http Test Method %d is not supported now\n",
	       progname, test.httptestmethod);
      xexit (EXIT_FAILURE);
    }
  if (test.socks5testmethod != SOCKS5_CONNECT)
    {
      fprintf (stderr,
	       "%s: INIT:Socks5 Test Method %d is not supported now\n",
	       progname, test.socks5testmethod);
      xexit (EXIT_FAILURE);
    }
  if (test.socks4testmethod != SOCKS4_CONNECT)
    {
      fprintf (stderr,
	       "%s: INIT:Socks4 Test Method %d is not supported now\n",
	       progname, test.socks4testmethod);
      xexit (EXIT_FAILURE);
    }


  /* myproxy's authentication data */
  if (my.mytype == HTTP_CONNECT_AUTH)
    {
      http_build_auth ();
    }
  else if (my.mytype == SOCKS5_CONNECT_AUTH)
    {
      s5_build_auth ();
    }

  /* myproxy's ip */
  if (my.mytype != DIRECT)
    {
      h = gethostbyname ((const char *) my.myhost);
      if (h == NULL)
	{
	  herror (my.myhost);
	  xfree ((void *) &(my.myhost));
	  xexit (EXIT_FAILURE);
	}
      else
	{
	  my.myip = *(struct in_addr *) (h->h_addr);
	  xfree ((void *) &(my.myhost));
	}
/* debug */
      /* printf ("addr=%s\n", inet_ntoa (my.myip)); */
      my.myaddr.sin_family = AF_INET;
      my.myaddr.sin_addr = my.myip;
      my.myaddr.sin_port = htons (my.myport);
      memset (&(my.myaddr.sin_zero), 0, sizeof (my.myaddr.sin_zero));

    }
  in = fopen (proxyknife_in, "r");
  if (in == NULL)
    {
            fprintf(stderr,__FILE__ " INIT:open %s ",proxyknife_in);
      perror ("fopen");
      xfree((void **)&proxyknife_in);
      xexit (EXIT_FAILURE);
    }else xfree((void **)&proxyknife_in);

  out = fopen (proxyknife_out, "w");
  if (out == NULL)
    {
      fprintf(stderr,__FILE__ " INIT:open %s ",proxyknife_out);
      perror("fopen");
      xfree((void **)&proxyknife_out);
      xexit (EXIT_FAILURE);
    }else xfree((void **)&proxyknife_out);

  setvbuf (out, (char *) NULL, _IONBF, 0);
  setvbuf (stdout, (char *) NULL, _IONBF, 0);
  setvbuf (stderr, (char *) NULL, _IONBF, 0);

  if (logfilename != NULL)
    {
      len = strlen (LOGSTDERR) + 1;	/* including trailing '\0' */
      if (strncmp (logfilename, LOGSTDERR, len) != 0)
	{
	  logfd = open (logfilename, O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR);
	  if (logfd == -1)
	    {
	      perror ("INIT:open");
	      xexit (EXIT_FAILURE);
	    }
	  else
	    {
	      fprintf (stderr, "Dup stderr to log file %d (%s)now!\n", logfd,
		       logfilename);
	      /* close(2) if necessary) */
	      if (dup2 (logfd, 2) == -1)
		{
		  perror ("INIT:dup2");
		  xexit (EXIT_FAILURE);
		}
	    }
	}
    }
}

/* Create thread loop and wait for thread termination.
 * */
void
THREAD ()
{
  int tidnum[MAXTHREADS], mainret, i;
  pthread_attr_t attr;
  pthread_t tid[MAXTHREADS];
  void *status;

  if ((threads > MAXTHREADS) || (threads < 1))
    {
      fprintf (stderr, "%s: THREAD:Threads between [1,%d] is permitted."
	       "Please modify \"thread=\" in .conf" "then  try again\n",
	       progname, MAXTHREADS);
      xexit (EXIT_FAILURE);
    }

  /* Initialize and set thread detached attribute */
  pthread_attr_init (&attr);
  /* If a thread requires joining, consider explicitly creating it as i
     joinable.  This provides portability as not all implementations 
     may create threads as joinable by default. */
  pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_JOINABLE);

  for (i = 0; i < threads; i++)
    {
      tidnum[i] = i;
      if ((mainret = pthread_create (tid + i, &attr, loop, tidnum + i)) == 0)
	{
	  /*printf("thread %d create %d\n",i,tid[i]); */
	}
      else
	{
	  perror ("THREAD:pthread_create");
	  xexit (EXIT_FAILURE);
	}
    }

  /* Free attribute and wait for the other threads */
  pthread_attr_destroy (&attr);
  for (i = 0; i < threads; i++)
    {
      if (pthread_join (tid[i], &status) == 0)
	{
	  /*printf("join thread %d\n",i,*(int *)status); */
	}
      else
	{
	  perror ("THREAD:pthread_join");
	  xexit (EXIT_FAILURE);
	}
    }
  pthread_mutex_destroy (&counter_mutex_in);
  pthread_mutex_destroy (&counter_mutex_out);
  pthread_mutex_destroy (&counter_mutex_create);
  pthread_mutex_destroy (&counter_mutex_malloc);
}

/* Do some cleaning: close file opened. */
void
END ()
{
  fclose (in);
  fclose (out);
  if (logfd != -1)
    close (logfd);
}
