/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1994/11/03 - 1995/03/10 by Erik Schnetter
 */

#include <X11/Xlib.h>
#include <alloca.h>
#include "header.h"



INT X_CreateWindow
  (Display* display, INT parent, INT x, INT y, INT width, INT height,
   INT border_width, INT depth, INT class, Visual* visual, INT mask,
   XSetWindowAttributes* attributes)
{
  return XCreateWindow
    (display, parent, x, y, width, height, border_width, depth, class, visual,
     mask, attributes);
}

INT X_CreateSimpleWindow
  (Display* display, INT parent, INT x, INT y, INT width, INT height,
   INT border_width, INT border, INT background)
{
  return XCreateSimpleWindow
    (display, parent, x, y, width, height, border_width, border, background);
}

void X_DestroyWindow (Display* display, INT window)
{
  XDestroyWindow (display, window);
}

void X_DestroySubwindows (Display* display, INT window)
{
  XDestroySubwindows (display, window);
}



void X_MapWindow (Display* display, INT window)
{
  XMapWindow (display, window);
}

void X_UnmapWindow (Display* display, INT window)
{
  XUnmapWindow (display, window);
}



void X_SelectInput (Display* display, INT window, INT mask)
{
  XSelectInput (display, window, mask);
}



void X_StoreName (Display* display, INT window, CHAR* name)
{
  XStoreName (display, window, name);
}

void* X_FetchName (Display* display, INT window)
{
  CHAR* ptr;
  XFetchName (display, window, &ptr);
  return ptr;
}



void X_ChangeWindowAttributes
  (Display* display, INT window, INT mask, XSetWindowAttributes* attributes)
{
  XChangeWindowAttributes (display, window, mask, attributes);
}

void X_SetWindowBackground (Display* display, INT window, INT pixel)
{
  XSetWindowBackground (display, window, pixel);
}

void X_SetWindowBackgroundPixmap (Display* display, INT window, INT pixmap)
{
  XSetWindowBackgroundPixmap (display, window, pixmap);
}

void X_SetWindowBorder (Display* display, INT window, INT pixel)
{
  XSetWindowBorder (display, window, pixel);
}

void X_SetWindowBorderPixmap (Display* display, INT window, INT pixmap)
{
  XSetWindowBorderPixmap (display, window, pixmap);
}

void X_SetWindowColormap (Display* display, INT window, INT colormap)
{
  XSetWindowColormap (display, window, colormap);
}



void X_ClearArea (Display* display, INT window,
		  INT x, INT y, INT width, INT height, BOOL exposures)
{
  XClearArea (display, window, x, y, width, height, exposures);
}

void X_ClearWindow (Display* display, INT window)
{
  XClearWindow (display, window);
}



void X_ConfigureWindow (Display* display, INT window, INT mask, INT* ints)
{
  XWindowChanges values;
  values.x = ints[0];
  values.y = ints[1];
  values.width = ints[2];
  values.height = ints[3];
  values.border_width = ints[4];
  values.sibling = ints[5];
  values.stack_mode = ints[6];
  XConfigureWindow (display, window, mask, &values);
}

void X_ConfigureWindow_x (Display* display, INT window, INT x)
{
  XWindowChanges values;
  values.x = x;
  XConfigureWindow (display, window, CWX, &values);
}

void X_ConfigureWindow_y (Display* display, INT window, INT y)
{
  XWindowChanges values;
  values.y = y;
  XConfigureWindow (display, window, CWY, &values);
}

void X_ConfigureWindow_width (Display* display, INT window, INT width)
{
  XWindowChanges values;
  values.width = width;
  XConfigureWindow (display, window, CWWidth, &values);
}

void X_ConfigureWindow_height (Display* display, INT window, INT height)
{
  XWindowChanges values;
  values.height = height;
  XConfigureWindow (display, window, CWHeight, &values);
}

void X_ConfigureWindow_border_width (Display* display, INT window,
				     INT border_width)
{
  XWindowChanges values;
  values.border_width = border_width;
  XConfigureWindow (display, window, CWBorderWidth, &values);
}

void X_ConfigureWindow_sibling (Display* display, INT window, INT sibling)
{
  XWindowChanges values;
  values. sibling= sibling;
  XConfigureWindow (display, window, CWSibling, &values);
}

void X_ConfigureWindow_stack_mode (Display* display, INT window,
				   INT stack_mode)
{
  XWindowChanges values;
  values.stack_mode = stack_mode;
  XConfigureWindow (display, window, CWStackMode, &values);
}



void X_MoveWindow (Display* display, INT window, INT x, INT y)
{
  XMoveWindow (display, window, x, y);
}

void X_ResizeWindow (Display* display, INT window, INT width, INT height)
{
  XResizeWindow (display, window, width, height);
}

void X_MoveResizeWindow (Display* display, INT window,
			 INT x, INT y, INT width, INT height)
{
  XMoveResizeWindow (display, window, x, y, width, height);
}

void X_SetWindowBorderWidth (Display* display, INT window, INT width)
{
  XSetWindowBorderWidth (display, window, width);
}



void X_ChangeSaveSet (Display* display, INT w, INT change_mode)
{
  XChangeSaveSet (display, w, change_mode);
}

void X_AddToSaveSet (Display* display, INT w)
{
  XAddToSaveSet (display, w);
}

void X_RemoveFromSaveSet (Display* display, INT w)
{
  XRemoveFromSaveSet (display, w);
}



BOOL X_GetWindowProperty
  (Display* display, INT window, INT property, INT offset, INT length,
   BOOL delete, INT req_type, INT* ints, unsigned char** exts)
{
  Atom   actual_type;
  int    actual_format;
  long   nitems;
  long   bytes;
  Status res;
  res = XGetWindowProperty
    (display, window, property, offset, length, delete, req_type, &actual_type,
     &actual_format, &nitems, &bytes, exts);
  ints[0] = actual_type;
  ints[1] = actual_format;
  ints[2] = nitems;
  ints[3] = bytes;
  return res;
}

Atom* X_ListProperties_first (Display* display, INT window, INT* ints)
{
  int   num_prop;
  Atom* handle;
  handle = XListProperties (display, window, &num_prop);
  ints[0] = num_prop;
  return handle;
}

void X_ListProperties_last (Atom* handle, INT* ints, INT num)
{
  int i;
  for (i=num; i--;) {
    ints[i] = handle[i];
  }
#if XLIBVERSION == 1104
  XFree ((char *)handle);
#else
  XFree (handle);
#endif
}

void X_ChangeProperty
  (Display* display, INT window, INT property, INT type, INT format, INT mode,
   CHAR* data, INT elements)
{
  XChangeProperty
    (display, window, property, type, format, mode, data, elements);
}

void X_RotateWindowProperties
  (Display* display, INT window, INT* ints, INT nprop, INT npositions)
{
  int i;
  Atom* properties = (Atom*) alloca (npositions * sizeof(Atom));
  for (i=nprop; i--;) {
    properties[i] = ints[i];
  }
  XRotateWindowProperties (display, window, properties, nprop, npositions);
}

void X_DeleteProperty (Display* display, INT window, INT property)
{
  XDeleteProperty (display, window, property);
}



void X_RaiseWindow (Display* display, INT window)
{
  XRaiseWindow (display, window);
}

void X_LowerWindow (Display* display, INT window)
{
  XLowerWindow (display, window);
}

void X_CirculateSubwindows (Display* display, INT window, INT direction)
{
  XCirculateSubwindows (display, window, direction);
}

void X_CirculateSubwindowsUp (Display* display, INT window)
{
  XCirculateSubwindowsUp (display, window);
}

void X_CirculateSubwindowsDown (Display* display, INT window)
{
  XCirculateSubwindowsDown (display, window);
}

void X_RestackWindows (Display* display, INT* ints, INT nwindows)
{
  Window* windows = (Window*) alloca (nwindows * sizeof(Window));
  int i;
  for (i=nwindows; i--;) { windows[i] = ints[i]; }
  XRestackWindows (display, windows, nwindows);
}



void X_DefineCursor (Display* display, INT window, INT cursor)
{
  XDefineCursor (display, window, cursor);
}

void X_UndefineCursor (Display* display, INT window)
{
  XUndefineCursor (display, window);
}
